/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.client.api.dto;

import io.camunda.zeebe.broker.client.api.RequestDispatchStrategy;
import io.camunda.zeebe.broker.client.api.UnsupportedBrokerResponseException;
import io.camunda.zeebe.broker.client.api.dto.BrokerError;
import io.camunda.zeebe.broker.client.api.dto.BrokerErrorResponse;
import io.camunda.zeebe.broker.client.api.dto.BrokerResponse;
import io.camunda.zeebe.protocol.impl.encoding.ErrorResponse;
import io.camunda.zeebe.protocol.record.MessageHeaderDecoder;
import io.camunda.zeebe.transport.ClientRequest;
import io.camunda.zeebe.util.buffer.BufferUtil;
import io.camunda.zeebe.util.buffer.BufferWriter;
import java.util.Optional;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BrokerRequest<T>
implements ClientRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(BrokerRequest.class);
    protected final MessageHeaderDecoder headerDecoder = new MessageHeaderDecoder();
    protected final ErrorResponse errorResponse = new ErrorResponse();
    protected final int schemaId;
    protected final int templateId;

    public BrokerRequest(int schemaId, int templateId) {
        this.schemaId = schemaId;
        this.templateId = templateId;
    }

    public Optional<Integer> getBrokerId() {
        return Optional.empty();
    }

    public abstract void setPartitionId(int var1);

    public void setAuthorization(String authorizationToken) {
    }

    public abstract boolean addressesSpecificPartition();

    public abstract boolean requiresPartitionId();

    public abstract BufferWriter getRequestWriter();

    public void serializeValue() {
        BufferWriter valueWriter = this.getRequestWriter();
        if (valueWriter != null) {
            int valueLength = valueWriter.getLength();
            UnsafeBuffer buffer = new UnsafeBuffer(new byte[valueLength]);
            valueWriter.write((MutableDirectBuffer)buffer, 0);
            this.setSerializedValue((DirectBuffer)buffer);
        }
    }

    protected abstract void setSerializedValue(DirectBuffer var1);

    protected abstract void wrapResponse(DirectBuffer var1);

    protected abstract BrokerResponse<T> readResponse();

    protected abstract T toResponseDto(DirectBuffer var1);

    public abstract String getType();

    public Optional<RequestDispatchStrategy> requestDispatchStrategy() {
        return Optional.empty();
    }

    public BrokerResponse<T> getResponse(DirectBuffer responseBuffer) {
        try {
            if (this.isValidResponse(responseBuffer)) {
                this.wrapResponse(responseBuffer);
                return this.readResponse();
            }
            if (this.isErrorResponse(responseBuffer)) {
                this.wrapErrorResponse(responseBuffer);
                BrokerError error = new BrokerError(this.errorResponse);
                return new BrokerErrorResponse(error);
            }
            throw new UnsupportedBrokerResponseException(this.headerDecoder.schemaId(), this.headerDecoder.templateId(), this.schemaId, this.templateId);
        }
        catch (Exception e) {
            LOGGER.error("Failed to read response: {}{}{}", new Object[]{e.getMessage(), System.lineSeparator(), BufferUtil.bufferAsHexString((DirectBuffer)responseBuffer)});
            throw e;
        }
    }

    protected void wrapResponseHeader(DirectBuffer buffer) {
        this.headerDecoder.wrap(buffer, 0);
    }

    protected boolean isErrorResponse(DirectBuffer buffer) {
        this.wrapResponseHeader(buffer);
        return this.headerDecoder.schemaId() == 0 && this.headerDecoder.templateId() == 10;
    }

    protected void wrapErrorResponse(DirectBuffer buffer) {
        this.errorResponse.wrap(buffer, 0, buffer.capacity());
    }

    protected boolean isValidResponse(DirectBuffer buffer) {
        this.wrapResponseHeader(buffer);
        return this.headerDecoder.schemaId() == this.schemaId && this.headerDecoder.templateId() == this.templateId;
    }
}

