/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.client.api.dto;

import io.camunda.zeebe.broker.client.api.UnsupportedBrokerResponseException;
import io.camunda.zeebe.broker.client.api.dto.BrokerRejection;
import io.camunda.zeebe.broker.client.api.dto.BrokerRejectionResponse;
import io.camunda.zeebe.broker.client.api.dto.BrokerRequest;
import io.camunda.zeebe.broker.client.api.dto.BrokerResponse;
import io.camunda.zeebe.protocol.impl.encoding.AuthInfo;
import io.camunda.zeebe.protocol.impl.encoding.ExecuteCommandRequest;
import io.camunda.zeebe.protocol.impl.encoding.ExecuteCommandResponse;
import io.camunda.zeebe.protocol.record.ExecuteCommandRequestEncoder;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.transport.RequestType;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public abstract class BrokerExecuteCommand<T>
extends BrokerRequest<T> {
    protected final ExecuteCommandRequest request = new ExecuteCommandRequest();
    protected final ExecuteCommandResponse response = new ExecuteCommandResponse();
    private final String type;

    public BrokerExecuteCommand(ValueType valueType, Intent intent) {
        super(0, 21);
        this.request.setValueType(valueType);
        this.request.setIntent(intent);
        this.type = valueType.name() + "#" + intent.name();
    }

    public long getKey() {
        return this.request.getKey();
    }

    public Intent getIntent() {
        return this.request.getIntent();
    }

    public ValueType getValueType() {
        return this.request.getValueType();
    }

    public int getPartitionId() {
        return this.request.getPartitionId();
    }

    @Override
    public void setPartitionId(int partitionId) {
        this.request.setPartitionId(partitionId);
    }

    public RequestType getRequestType() {
        return RequestType.COMMAND;
    }

    public AuthInfo getAuthorization() {
        return this.request.getAuthorization();
    }

    @Override
    public void setAuthorization(String authorizationToken) {
        this.request.setAuthorization(new AuthInfo().setFormatProp(AuthInfo.AuthDataFormat.JWT).setAuthData(authorizationToken));
    }

    @Override
    public boolean addressesSpecificPartition() {
        return this.getPartitionId() != ExecuteCommandRequestEncoder.partitionIdNullValue();
    }

    @Override
    public boolean requiresPartitionId() {
        return true;
    }

    @Override
    protected void setSerializedValue(DirectBuffer buffer) {
        this.request.setValue(buffer, 0, buffer.capacity());
    }

    @Override
    protected void wrapResponse(DirectBuffer buffer) {
        this.response.wrap(buffer, 0, buffer.capacity());
    }

    @Override
    protected BrokerResponse<T> readResponse() {
        if (this.isRejection()) {
            BrokerRejection brokerRejection = new BrokerRejection(this.request.getIntent(), this.request.getKey(), this.response.getRejectionType(), this.response.getRejectionReason());
            return new BrokerRejectionResponse(brokerRejection);
        }
        if (this.isValidResponse()) {
            Object responseDto = this.toResponseDto(this.response.getValue());
            return new BrokerResponse(responseDto, this.response.getPartitionId(), this.response.getKey());
        }
        throw new UnsupportedBrokerResponseException(this.request.getValueType().name(), this.response.getValueType().name());
    }

    @Override
    public String getType() {
        return this.type;
    }

    public int getLength() {
        return this.request.getLength();
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        this.request.write(buffer, offset);
    }

    protected boolean isValidResponse() {
        return this.response.getValueType() == this.request.getValueType();
    }

    protected boolean isRejection() {
        return this.response.getRecordType() == RecordType.COMMAND_REJECTION;
    }

    public long getOperationReference() {
        return this.request.getOperationReference();
    }

    public void setOperationReference(long operationReference) {
        this.request.setOperationReference(operationReference);
    }
}

