/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.client.api;

import io.camunda.zeebe.broker.client.api.BrokerClientException;

public class PartitionNotFoundException
extends BrokerClientException {
    private static final String DEFAULT_ERROR_MESSAGE = "Expected to execute command on partition %d, but either it does not exist, or the gateway is not yet aware of it";
    private final int partitionId;

    public PartitionNotFoundException(int partitionId) {
        this(String.format(DEFAULT_ERROR_MESSAGE, partitionId), partitionId);
    }

    public PartitionNotFoundException(String message, int partitionId) {
        super(message);
        this.partitionId = partitionId;
    }

    public PartitionNotFoundException(String message, Throwable cause, int partitionId) {
        super(message, cause);
        this.partitionId = partitionId;
    }

    public int getPartitionId() {
        return this.partitionId;
    }
}

