/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.security.sso.model;

import io.camunda.tasklist.property.TasklistProperties;
import io.camunda.tasklist.webapp.security.sso.TokenAuthentication;
import io.camunda.tasklist.webapp.security.sso.model.ClusterMetadata;
import java.io.IOException;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class C8ConsoleService {
    private static final Logger LOGGER = LoggerFactory.getLogger(C8ConsoleService.class);
    private static final String CONSOLE_CLUSTER_TEMPLATE = "%s/external/organizations/%s/clusters";
    @Autowired
    private TasklistProperties tasklistProperties;
    @Autowired
    @Qualifier(value="auth0_restTemplate")
    private RestTemplate restTemplate;
    private ClusterMetadata clusterMetadata;

    public ClusterMetadata getClusterMetadata() {
        if (this.clusterMetadata == null) {
            try {
                this.clusterMetadata = this.retrieveClusterMetadata();
            }
            catch (Exception e) {
                LOGGER.error("Couldn't retrieve ClusterMetadata, return null.", (Throwable)e);
                this.clusterMetadata = null;
            }
        }
        return this.clusterMetadata;
    }

    private ClusterMetadata retrieveClusterMetadata() {
        TokenAuthentication authentication = (TokenAuthentication)SecurityContextHolder.getContext().getAuthentication();
        if (authentication.isAuthenticated()) {
            String operationName = "retrieve cluster metadata";
            RetryPolicy retryPolicy = ((RetryPolicy)new RetryPolicy().handle(IOException.class)).withDelay(Duration.ofMillis(500L)).withMaxAttempts(5).onRetry(e -> LOGGER.debug("Retrying #{} {}", (Object)e.getAttemptCount(), (Object)"retrieve cluster metadata")).onAbort(e -> LOGGER.error("Abort {} by {}", (Object)"retrieve cluster metadata", (Object)e.getFailure())).onRetriesExceeded(e -> LOGGER.error("Retries {} exceeded for {}", (Object)e.getAttemptCount(), (Object)"retrieve cluster metadata"));
            ClusterMetadata clusterMetadata = (ClusterMetadata)Failsafe.with((Policy)retryPolicy, (Policy[])new RetryPolicy[0]).get(() -> this.getClusterMetadataFromConsole(authentication.getAccessToken()));
            if (clusterMetadata != null) {
                return this.addModelerAndConsoleLinksIfNotExists(clusterMetadata);
            }
        }
        return null;
    }

    private ClusterMetadata addModelerAndConsoleLinksIfNotExists(ClusterMetadata clusterMetadata) {
        TreeMap<ClusterMetadata.AppName, String> urls = new TreeMap<ClusterMetadata.AppName, String>(clusterMetadata.getUrls());
        String organizationId = this.tasklistProperties.getAuth0().getOrganization();
        String domain = this.tasklistProperties.getCloud().getPermissionAudience();
        String clusterId = this.tasklistProperties.getCloud().getClusterId();
        if (!urls.containsKey((Object)ClusterMetadata.AppName.MODELER)) {
            urls.put(ClusterMetadata.AppName.MODELER, String.format("https://%s.%s/org/%s", new Object[]{ClusterMetadata.AppName.MODELER, domain, organizationId}));
        }
        if (!urls.containsKey((Object)ClusterMetadata.AppName.CONSOLE)) {
            urls.put(ClusterMetadata.AppName.CONSOLE, String.format("https://%s.%s/org/%s/cluster/%s", new Object[]{ClusterMetadata.AppName.CONSOLE, domain, organizationId, clusterId}));
        }
        clusterMetadata.setUrls(urls);
        return clusterMetadata;
    }

    private ClusterMetadata getClusterMetadataFromConsole(String accessToken) {
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(List.of(MediaType.APPLICATION_JSON));
        headers.setBearerAuth(accessToken);
        String url = String.format(CONSOLE_CLUSTER_TEMPLATE, this.tasklistProperties.getCloud().getConsoleUrl(), this.tasklistProperties.getAuth0().getOrganization());
        ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)headers), ClusterMetadata[].class, new Object[0]);
        ClusterMetadata[] clustersMetadata = (ClusterMetadata[])response.getBody();
        if (clustersMetadata != null) {
            Optional<ClusterMetadata> clusterMetadataMaybe = Arrays.stream(clustersMetadata).filter(cm -> cm.getUuid().equals(this.tasklistProperties.getCloud().getClusterId())).findFirst();
            return clusterMetadataMaybe.orElse(null);
        }
        return null;
    }
}

