/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.security.oauth;

import io.camunda.identity.sdk.Identity;
import io.camunda.tasklist.webapp.security.oauth.IdentityTenantAwareJwtAuthenticationToken;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"identity-auth"})
public class IdentityJwt2AuthenticationTokenConverter
implements Converter<Jwt, AbstractAuthenticationToken> {
    @Autowired
    private Identity identity;

    public AbstractAuthenticationToken convert(Jwt jwt) {
        try {
            this.identity.authentication().verifyToken(jwt.getTokenValue());
            return new IdentityTenantAwareJwtAuthenticationToken(jwt, null, jwt.getSubject());
        }
        catch (Exception e) {
            throw new InsufficientAuthenticationException(e.getMessage());
        }
    }
}

