/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.security.identity;

import io.camunda.identity.sdk.Identity;
import io.camunda.identity.sdk.authentication.AccessToken;
import io.camunda.tasklist.util.CollectionUtil;
import io.camunda.tasklist.webapp.graphql.entity.UserDTO;
import io.camunda.tasklist.webapp.security.Permission;
import io.camunda.tasklist.webapp.security.UserReader;
import io.camunda.tasklist.webapp.security.identity.IdentityAuthentication;
import io.camunda.tasklist.webapp.security.identity.PermissionConverter;
import io.camunda.tasklist.webapp.security.oauth.IdentityTenantAwareJwtAuthenticationToken;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"identity-auth"})
public class IdentityUserReader
implements UserReader {
    @Autowired
    private Identity identity;

    @Override
    public Optional<UserDTO> getCurrentUserBy(Authentication authentication) {
        if (authentication instanceof IdentityAuthentication) {
            IdentityAuthentication identityAuthentication = (IdentityAuthentication)authentication;
            return Optional.of(new UserDTO().setUserId(identityAuthentication.getName()).setDisplayName(identityAuthentication.getUserDisplayName()).setPermissions(identityAuthentication.getPermissions()).setTenants(identityAuthentication.getTenants()).setGroups(identityAuthentication.getGroups()));
        }
        if (authentication instanceof IdentityTenantAwareJwtAuthenticationToken) {
            IdentityTenantAwareJwtAuthenticationToken identityTenantAwareToken = (IdentityTenantAwareJwtAuthenticationToken)authentication;
            AccessToken accessToken = this.identity.authentication().verifyToken(((Jwt)identityTenantAwareToken.getPrincipal()).getTokenValue());
            List<Permission> permissions = accessToken.getPermissions().stream().map(PermissionConverter.getInstance()::convert).collect(Collectors.toList());
            String userDisplayName = accessToken.getUserDetails().getName().orElse(identityTenantAwareToken.getName());
            return Optional.of(new UserDTO().setUserId(identityTenantAwareToken.getName()).setDisplayName(userDisplayName).setApiUser(true).setPermissions(permissions).setTenants(identityTenantAwareToken.getTenants()));
        }
        return Optional.empty();
    }

    @Override
    public String getCurrentOrganizationId() {
        return "null";
    }

    @Override
    public List<UserDTO> getUsersByUsernames(List<String> usernames) {
        return CollectionUtil.map(usernames, name -> new UserDTO().setUserId((String)name).setDisplayName((String)name));
    }

    @Override
    public Optional<String> getUserToken(Authentication authentication) {
        throw new UnsupportedOperationException("Get token is not supported for Identity authentication");
    }
}

