/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.api.rest.v1.entities;

import io.camunda.tasklist.entities.DraftTaskVariableEntity;
import io.camunda.tasklist.entities.TaskVariableEntity;
import io.camunda.tasklist.entities.VariableEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import java.util.StringJoiner;

public class VariableResponse {
    @Schema(description="The ID of the variable")
    private String id;
    @Schema(description="The name of the variable")
    private String name;
    @Schema(description="The full value of the variable")
    private String value;
    @Schema(description="The draft value of the variable")
    private DraftVariableValue draft;
    @Schema(description="The tenant ID associated with the variable")
    private String tenantId;

    public String getId() {
        return this.id;
    }

    public VariableResponse setId(String id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public VariableResponse setName(String name) {
        this.name = name;
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public VariableResponse setValue(String value) {
        this.value = value;
        return this;
    }

    public DraftVariableValue getDraft() {
        return this.draft;
    }

    public VariableResponse setDraft(DraftVariableValue draft) {
        this.draft = draft;
        return this;
    }

    public VariableResponse addDraft(DraftTaskVariableEntity draftTaskVariable) {
        this.draft = new DraftVariableValue().setValue(draftTaskVariable.getFullValue());
        return this;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public VariableResponse setTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public static VariableResponse createFrom(VariableEntity variableEntity) {
        return new VariableResponse().setId(variableEntity.getId()).setName(variableEntity.getName()).setValue(variableEntity.getFullValue()).setTenantId(variableEntity.getTenantId());
    }

    public static VariableResponse createFrom(DraftTaskVariableEntity draftTaskVariable) {
        return new VariableResponse().setId(draftTaskVariable.getId()).setName(draftTaskVariable.getName()).setTenantId(draftTaskVariable.getTenantId()).setDraft(new DraftVariableValue().setValue(draftTaskVariable.getFullValue()));
    }

    public static VariableResponse createFrom(TaskVariableEntity variableEntity) {
        return new VariableResponse().setId(variableEntity.getId()).setName(variableEntity.getName()).setValue(variableEntity.getFullValue()).setTenantId(variableEntity.getTenantId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VariableResponse that = (VariableResponse)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value) && Objects.equals(this.draft, that.draft) && Objects.equals(this.tenantId, that.tenantId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.value, this.draft, this.tenantId);
    }

    public String toString() {
        return "VariableResponse{id='" + this.id + "', name='" + this.name + "', value='" + this.value + "', draft=" + String.valueOf(this.draft) + ", tenantId='" + this.tenantId + "'}";
    }

    public static class DraftVariableValue {
        private String value;

        public String getValue() {
            return this.value;
        }

        public DraftVariableValue setValue(String value) {
            this.value = value;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DraftVariableValue that = (DraftVariableValue)o;
            return Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return new StringJoiner(", ", DraftVariableValue.class.getSimpleName() + "[", "]").add("value='" + this.value + "'").toString();
        }
    }
}

