/*
 * Decompiled with CFR 0.152.
 */
package com.auth0;

import com.auth0.SameSite;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.Validate;

class AuthCookie {
    private static final int MAX_AGE_SECONDS = 600;
    private final String key;
    private final String value;
    private boolean secure;
    private SameSite sameSite;
    private String cookiePath;

    AuthCookie(String key, String value) {
        Validate.notNull((Object)key, (String)"Key must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)value, (String)"Value must not be null", (Object[])new Object[0]);
        this.key = key;
        this.value = value;
    }

    void setPath(String path) {
        this.cookiePath = path;
    }

    void setSecure(boolean secure) {
        this.secure = secure;
    }

    void setSameSite(SameSite sameSite) {
        this.sameSite = sameSite;
    }

    String buildHeaderString() {
        String baseCookieString = String.format("%s=%s; HttpOnly; Max-Age=%d", AuthCookie.encode(this.key), AuthCookie.encode(this.value), 600);
        if (this.cookiePath != null) {
            baseCookieString = baseCookieString.concat(String.format("; Path=%s", this.cookiePath));
        }
        if (this.sameSite != null) {
            baseCookieString = baseCookieString.concat(String.format("; SameSite=%s", AuthCookie.encode(this.sameSite.getValue())));
        }
        if (this.secure) {
            baseCookieString = baseCookieString.concat("; Secure");
        }
        return baseCookieString;
    }

    private static String encode(String valueToEncode) {
        try {
            return URLEncoder.encode(valueToEncode, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError("UTF-8 character set not supported", e.getCause());
        }
    }
}

