/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.zeebeimport.os;

import io.camunda.tasklist.CommonUtils;
import io.camunda.tasklist.data.conditionals.OpenSearchCondition;
import io.camunda.tasklist.entities.meta.ImportPositionEntity;
import io.camunda.tasklist.util.Either;
import io.camunda.tasklist.util.OpenSearchUtil;
import io.camunda.tasklist.zeebeimport.ImportPositionHolder;
import io.camunda.tasklist.zeebeimport.ImportPositionHolderAbstract;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch._types.FieldValue;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.BulkRequest;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.opensearch.client.opensearch.core.UpdateRequest;
import org.opensearch.client.opensearch.core.bulk.BulkOperation;
import org.opensearch.client.opensearch.core.bulk.IndexOperation;
import org.opensearch.client.opensearch.core.search.Hit;
import org.opensearch.client.util.ObjectBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;

@Component
@DependsOn(value={"tasklistSchemaStartup"})
@Conditional(value={OpenSearchCondition.class})
public class ImportPositionHolderOpenSearch
extends ImportPositionHolderAbstract
implements ImportPositionHolder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImportPositionHolderOpenSearch.class);
    @Qualifier(value="tasklistZeebeOsClient")
    @Autowired
    private OpenSearchClient osClient;

    @Override
    public ImportPositionEntity getLatestLoadedPosition(String aliasTemplate, int partitionId) throws IOException {
        Query query = OpenSearchUtil.joinWithAnd((ObjectBuilder[])new ObjectBuilder[]{new Query.Builder().term(t -> t.field("aliasName").value(FieldValue.of((String)aliasTemplate))), new Query.Builder().term(t -> t.field("partitionId").value(FieldValue.of((long)partitionId)))});
        SearchRequest searchRequest = new SearchRequest.Builder().query(query).size(Integer.valueOf(10)).index(List.of(this.importPositionType.getAlias())).build();
        SearchResponse searchResponse = this.osClient.search(searchRequest, ImportPositionEntity.class);
        List hits = searchResponse.hits().hits();
        ImportPositionEntity position = new ImportPositionEntity().setAliasName(aliasTemplate).setPartitionId(partitionId);
        for (Hit hit : hits) {
            position = (ImportPositionEntity)hit.source();
        }
        LOGGER.debug("Latest loaded position for alias [{}] and partitionId [{}]: {}", new Object[]{aliasTemplate, partitionId, position});
        return position;
    }

    @Override
    public Either<Throwable, Boolean> updateImportPositions(Map<String, ImportPositionEntity> positions) {
        Either<Exception, BulkRequest> preparedBulkRequest = this.prepareBulkRequest(positions);
        if (preparedBulkRequest.isLeft()) {
            Exception e = (Exception)preparedBulkRequest.getLeft();
            return Either.left((Object)e);
        }
        try {
            BulkRequest bulkRequest = (BulkRequest)preparedBulkRequest.get();
            this.withImportPositionTimer(() -> {
                OpenSearchUtil.processBulkRequest((OpenSearchClient)this.osClient, (BulkRequest)bulkRequest);
                return null;
            });
            return Either.right((Object)true);
        }
        catch (Throwable e) {
            LOGGER.error("Error occurred while persisting latest loaded position", e);
            return Either.left((Object)e);
        }
    }

    private Either<Exception, BulkRequest> prepareBulkRequest(Map<String, ImportPositionEntity> positions) {
        BulkRequest.Builder bulkRequest = new BulkRequest.Builder();
        ArrayList ops = new ArrayList();
        if (positions.size() > 0) {
            Either preparedUpdateRequests = (Either)positions.values().stream().map(this::prepareUpdateRequest).collect(Either.collectorFoldingLeft());
            if (preparedUpdateRequests.isLeft()) {
                Exception e = (Exception)preparedUpdateRequests.getLeft();
                return Either.left((Object)e);
            }
            ((List)preparedUpdateRequests.get()).forEach(p -> ops.add((BulkOperation)new BulkOperation.Builder().index(IndexOperation.of(io -> (ObjectBuilder)((IndexOperation.Builder)io.index(this.importPositionType.getFullQualifiedName())).document(p.doc()).id(p.id()))).build()));
        }
        return Either.right((Object)bulkRequest.operations(ops).build());
    }

    private Either<Exception, UpdateRequest> prepareUpdateRequest(ImportPositionEntity position) {
        try {
            String index = this.importPositionType.getFullQualifiedName();
            String source = this.objectMapper.writeValueAsString((Object)position);
            HashMap<String, Object> updateFields = new HashMap<String, Object>();
            updateFields.put("position", position.getPosition());
            updateFields.put("indexName", position.getIndexName());
            updateFields.put("sequence", position.getSequence());
            UpdateRequest updateRequest = new UpdateRequest.Builder().index(index).id(position.getId()).upsert((Object)CommonUtils.getJsonObjectFromEntity(updateFields)).doc((Object)CommonUtils.getJsonObjectFromEntity((Object)position)).docAsUpsert(Boolean.valueOf(true)).build();
            return Either.right((Object)updateRequest);
        }
        catch (Exception e) {
            LOGGER.error(String.format("Error occurred while preparing request to update processed position for %s", position.getAliasName()), (Throwable)e);
            return Either.left((Object)e);
        }
    }
}

