/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.util;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.tasklist.entities.TasklistEntity;
import io.camunda.tasklist.exceptions.NotFoundException;
import io.camunda.tasklist.exceptions.PersistenceException;
import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import io.camunda.tasklist.schema.indices.IndexDescriptor;
import io.camunda.tasklist.schema.templates.TemplateDescriptor;
import io.camunda.tasklist.tenant.TenantAwareOpenSearchClient;
import io.camunda.tasklist.util.CollectionUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.opensearch.client.opensearch.OpenSearchAsyncClient;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch._types.OpenSearchException;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch._types.query_dsl.BoolQuery;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryVariant;
import org.opensearch.client.opensearch.core.BulkRequest;
import org.opensearch.client.opensearch.core.BulkResponse;
import org.opensearch.client.opensearch.core.ClearScrollRequest;
import org.opensearch.client.opensearch.core.DeleteByQueryRequest;
import org.opensearch.client.opensearch.core.DeleteByQueryResponse;
import org.opensearch.client.opensearch.core.ReindexRequest;
import org.opensearch.client.opensearch.core.ReindexResponse;
import org.opensearch.client.opensearch.core.ScrollRequest;
import org.opensearch.client.opensearch.core.ScrollResponse;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.opensearch.client.opensearch.core.UpdateRequest;
import org.opensearch.client.opensearch.core.bulk.BulkResponseItem;
import org.opensearch.client.opensearch.core.search.Hit;
import org.opensearch.client.opensearch.core.search.HitsMetadata;
import org.opensearch.client.opensearch.indices.RefreshRequest;
import org.opensearch.client.opensearch.indices.RefreshResponse;
import org.opensearch.client.util.ObjectBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OpenSearchUtil {
    public static final String ZEEBE_INDEX_DELIMITER = "_";
    public static final String SCROLL_KEEP_ALIVE_MS = "60000ms";
    public static final String INTERNAL_SCROLL_KEEP_ALIVE_MS = "30000ms";
    public static final int QUERY_MAX_SIZE = 10000;
    public static final int UPDATE_RETRY_COUNT = 3;
    public static final Function<Hit, Long> SEARCH_HIT_ID_TO_LONG = hit -> Long.valueOf(hit.id());
    public static final Function<Hit, String> SEARCH_HIT_ID_TO_STRING = Hit::id;
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenSearchUtil.class);

    public static void clearScroll(String scrollId, OpenSearchClient osClient) {
        if (scrollId != null) {
            ClearScrollRequest clearScrollRequest = new ClearScrollRequest.Builder().scrollId(scrollId, new String[0]).build();
            try {
                osClient.clearScroll(clearScrollRequest);
            }
            catch (Exception e) {
                LOGGER.warn("Error occurred when clearing the scroll with id [{}]", (Object)scrollId, (Object)e);
            }
        }
    }

    public static Query joinWithAnd(ObjectBuilder ... queries) {
        List notNullQueries = CollectionUtil.throwAwayNullElements((Object[])queries);
        if (notNullQueries.size() == 0) {
            return new Query.Builder().build();
        }
        BoolQuery.Builder boolQ = OpenSearchUtil.boolQuery();
        for (ObjectBuilder queryBuilder : notNullQueries) {
            Object query = queryBuilder.build();
            if (query instanceof QueryVariant) {
                QueryVariant qv = (QueryVariant)query;
                boolQ.must(qv._toQuery(), new Query[0]);
                continue;
            }
            if (query instanceof Query) {
                Query q = (Query)query;
                boolQ.must(q, new Query[0]);
                continue;
            }
            throw new TasklistRuntimeException("Queries should be of type [Query] or [QueryVariant]");
        }
        return (Query)new Query.Builder().bool(boolQ.build()).build();
    }

    public static Query createMatchNoneQuery() {
        BoolQuery boolQuery = new BoolQuery.Builder().must(must -> must.matchNone(none -> (ObjectBuilder)none.queryName("matchNone"))).build();
        return boolQuery._toQuery();
    }

    public static Query joinWithAnd(Query ... queries) {
        List notNullQueries = CollectionUtil.throwAwayNullElements((Object[])queries);
        if (notNullQueries.size() == 0) {
            return new Query.Builder().build();
        }
        BoolQuery.Builder boolQ = OpenSearchUtil.boolQuery();
        for (Query queryBuilder : notNullQueries) {
            Query query = queryBuilder;
            if (query instanceof QueryVariant) {
                QueryVariant qv = (QueryVariant)query;
                boolQ.must(qv._toQuery(), new Query[0]);
                continue;
            }
            boolQ.must(query, new Query[0]);
        }
        return (Query)new Query.Builder().bool(boolQ.build()).build();
    }

    public static Query.Builder joinQueryBuilderWithAnd(ObjectBuilder ... queries) {
        List notNullQueries = CollectionUtil.throwAwayNullElements((Object[])queries);
        Query.Builder queryBuilder = new Query.Builder();
        switch (notNullQueries.size()) {
            case 0: {
                return null;
            }
        }
        BoolQuery.Builder boolQ = OpenSearchUtil.boolQuery();
        for (ObjectBuilder query : notNullQueries) {
            boolQ.must((Query)query.build(), new Query[0]);
        }
        queryBuilder.bool(boolQ.build());
        return queryBuilder;
    }

    public static Query.Builder joinQueryBuilderWithOr(ObjectBuilder ... queries) {
        List notNullQueries = CollectionUtil.throwAwayNullElements((Object[])queries);
        Query.Builder queryBuilder = new Query.Builder();
        switch (notNullQueries.size()) {
            case 0: {
                return null;
            }
        }
        BoolQuery.Builder boolQ = OpenSearchUtil.boolQuery();
        for (ObjectBuilder query : notNullQueries) {
            boolQ.should((Query)query.build(), new Query[0]);
        }
        queryBuilder.bool(boolQ.build());
        return queryBuilder;
    }

    public static <T> T fromSearchHit(String searchHitString, ObjectMapper objectMapper, Class<T> clazz) {
        Object entity;
        try {
            entity = objectMapper.readValue(searchHitString, clazz);
        }
        catch (IOException e) {
            throw new TasklistRuntimeException(String.format("Error while reading entity of type %s from Elasticsearch!", clazz.getName()), (Throwable)e);
        }
        return (T)entity;
    }

    public static CompletableFuture<ScrollResponse<Object>> scrollAsync(ScrollRequest scrollRequest, Executor executor, OpenSearchAsyncClient osClient) {
        CompletableFuture searchFuture = new CompletableFuture();
        try {
            CompletableFuture response = osClient.scroll(scrollRequest, Object.class);
            return response;
        }
        catch (IOException e) {
            throw new TasklistRuntimeException((Throwable)e);
        }
    }

    public static BoolQuery.Builder boolQuery() {
        return new BoolQuery.Builder();
    }

    public static CompletableFuture<DeleteByQueryResponse> deleteByQueryAsync(DeleteByQueryRequest deleteRequest, Executor executor, OpenSearchAsyncClient osClient) {
        try {
            return osClient.deleteByQuery(deleteRequest);
        }
        catch (IOException e) {
            throw new TasklistRuntimeException((Throwable)e);
        }
    }

    public static CompletableFuture<ReindexResponse> reindexAsync(ReindexRequest reindexRequest, Executor executor, OpenSearchAsyncClient osClient) {
        try {
            return osClient.reindex(reindexRequest);
        }
        catch (IOException e) {
            throw new TasklistRuntimeException((Throwable)e);
        }
    }

    public static void processBulkRequest(OpenSearchClient osClient, BulkRequest bulkRequest) throws PersistenceException {
        if (bulkRequest.operations().size() > 0) {
            try {
                LOGGER.debug("************* FLUSH BULK START *************");
                BulkResponse bulkItemResponses = osClient.bulk(bulkRequest);
                List items = bulkItemResponses.items();
                for (BulkResponseItem responseItem : items) {
                    if (responseItem.error() == null) continue;
                    LOGGER.error(String.format("%s failed for type [%s] and id [%s]: %s", responseItem.operationType(), responseItem.index(), responseItem.id(), responseItem.error().reason()), (Object)"error on OpenSearch BulkRequest");
                    throw new PersistenceException("Operation failed: " + responseItem.error().reason(), (Throwable)new TasklistRuntimeException(responseItem.error().reason()), Integer.valueOf(responseItem.id()));
                }
                LOGGER.debug("************* FLUSH BULK FINISH *************");
            }
            catch (IOException ex) {
                throw new PersistenceException("Error when processing bulk request against OpenSearch: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public static void refreshIndicesFor(OpenSearchClient osClient, String indexPattern) {
        RefreshRequest refreshRequest = new RefreshRequest.Builder().index(List.of(indexPattern)).build();
        try {
            RefreshResponse refresh = osClient.indices().refresh(refreshRequest);
            if (refresh.shards().failures().size() > 0) {
                LOGGER.warn("Unable to refresh indices: {}", (Object)indexPattern);
            }
        }
        catch (Exception ex) {
            LOGGER.warn(String.format("Unable to refresh indices: %s", indexPattern), (Throwable)ex);
        }
    }

    public static <T> List<T> mapSearchHits(List<Hit> searchHits, ObjectMapper objectMapper, JavaType valueType) {
        return CollectionUtil.map(searchHits, searchHit -> objectMapper.convertValue(searchHit.source(), valueType));
    }

    public static CompletableFuture<SearchResponse<Object>> searchAsync(SearchRequest searchRequest, Executor executor, OpenSearchAsyncClient osClient) {
        CompletableFuture searchFuture = new CompletableFuture();
        try {
            return osClient.search(searchRequest, Object.class);
        }
        catch (IOException e) {
            throw new TasklistRuntimeException((Throwable)e);
        }
    }

    public static void scrollWith(SearchRequest.Builder searchRequest, OpenSearchClient osClient, Consumer<List<Hit>> searchHitsProcessor, Consumer<Map> aggsProcessor, Consumer<HitsMetadata> firstResponseConsumer) throws IOException {
        searchRequest.scroll(Time.of(t -> t.time(INTERNAL_SCROLL_KEEP_ALIVE_MS)));
        SearchResponse response = osClient.search(searchRequest.build(), Object.class);
        if (firstResponseConsumer != null) {
            firstResponseConsumer.accept(response.hits());
        }
        if (aggsProcessor != null) {
            aggsProcessor.accept(response.aggregations());
        }
        String scrollId = response.scrollId();
        HitsMetadata hits = response.hits();
        try {
            while (hits.hits().size() != 0) {
                if (searchHitsProcessor != null) {
                    searchHitsProcessor.accept(response.hits().hits());
                }
                ScrollRequest.Builder scrollRequest = new ScrollRequest.Builder();
                scrollRequest.scrollId(scrollId);
                scrollRequest.scroll(Time.of(t -> t.time(SCROLL_KEEP_ALIVE_MS)));
                response = osClient.scroll(scrollRequest.build(), Object.class);
                scrollId = response.scrollId();
                hits = response.hits();
            }
        }
        catch (Exception e) {
            throw new TasklistRuntimeException(e.getMessage());
        }
        finally {
            OpenSearchUtil.clearScroll(scrollId, osClient);
        }
    }

    public static <T> void scrollWith(SearchRequest.Builder searchRequest, OpenSearchClient osClient, Consumer<List<Hit<T>>> searchHitsProcessor, Consumer<Map> aggsProcessor, Class<T> clazz, Consumer<HitsMetadata<T>> firstResponseConsumer) throws IOException {
        searchRequest.scroll(Time.of(t -> t.time(INTERNAL_SCROLL_KEEP_ALIVE_MS)));
        SearchResponse response = osClient.search(searchRequest.build(), clazz);
        if (firstResponseConsumer != null) {
            firstResponseConsumer.accept(response.hits());
        }
        if (aggsProcessor != null) {
            aggsProcessor.accept(response.aggregations());
        }
        String scrollId = response.scrollId();
        HitsMetadata hits = response.hits();
        try {
            while (hits.hits().size() != 0) {
                if (searchHitsProcessor != null) {
                    searchHitsProcessor.accept(response.hits().hits());
                }
                ScrollRequest.Builder scrollRequest = new ScrollRequest.Builder();
                scrollRequest.scrollId(scrollId);
                scrollRequest.scroll(Time.of(t -> t.time(SCROLL_KEEP_ALIVE_MS)));
                response = osClient.scroll(scrollRequest.build(), clazz);
                scrollId = response.scrollId();
                hits = response.hits();
            }
        }
        catch (Exception e) {
            throw new TasklistRuntimeException(e.getMessage());
        }
        finally {
            OpenSearchUtil.clearScroll(scrollId, osClient);
        }
    }

    public static String whereToSearch(IndexDescriptor descriptor, QueryType queryType) {
        switch (queryType.ordinal()) {
            case 0: {
                return descriptor.getFullQualifiedName();
            }
        }
        return descriptor.getAlias();
    }

    public static <T> List<T> mapSearchHits(List<? extends Hit<?>> searchHits, ObjectMapper objectMapper, Class<T> clazz) {
        return CollectionUtil.map(searchHits, searchHit -> OpenSearchUtil.fromSearchHit(searchHit.source().toString(), objectMapper, clazz));
    }

    public static <T> List<T> scrollFieldToList(SearchRequest.Builder request, String fieldName, OpenSearchClient esClient) throws IOException {
        ArrayList result = new ArrayList();
        Function<Hit, Object> searchHitFieldToString = searchHit -> ((LinkedHashMap)searchHit.source()).get(fieldName);
        Consumer<List<Hit>> collectFields = hits -> result.addAll(CollectionUtil.map((Collection)hits, (Function)searchHitFieldToString));
        OpenSearchUtil.scrollWith(request, esClient, collectFields, null, null);
        return result;
    }

    public static SearchRequest.Builder createSearchRequest(TemplateDescriptor template) {
        return OpenSearchUtil.createSearchRequest(template, QueryType.ALL);
    }

    public static <T> T getRawResponseWithTenantCheck(String id, IndexDescriptor descriptor, QueryType queryType, TenantAwareOpenSearchClient tenantAwareClient, Class<T> objectClass) throws IOException {
        SearchRequest.Builder request = OpenSearchUtil.createSearchRequest(descriptor, queryType).query(q -> q.ids(ids -> ids.values(id, new String[0])));
        SearchResponse response = tenantAwareClient.search(request, objectClass);
        if (response.hits().total().value() == 1L) {
            return (T)((Hit)response.hits().hits().get(0)).source();
        }
        if (response.hits().total().value() > 1L) {
            throw new NotFoundException(String.format("Unique %s with id %s was not found", descriptor.getIndexName(), id));
        }
        throw new NotFoundException(String.format("%s with id %s was not found", descriptor.getIndexName(), id));
    }

    public static SearchRequest.Builder createSearchRequest(IndexDescriptor descriptor, QueryType queryType) {
        SearchRequest.Builder builder = new SearchRequest.Builder();
        builder.index(OpenSearchUtil.whereToSearch(descriptor, queryType), new String[0]);
        return builder;
    }

    public static <T extends TasklistEntity> List<T> scroll(SearchRequest.Builder searchRequest, Class<T> clazz, OpenSearchClient osClient) throws IOException {
        return OpenSearchUtil.scroll(searchRequest, clazz, osClient, null);
    }

    public static <T extends TasklistEntity> List<T> scroll(SearchRequest.Builder searchRequest, Class<T> clazz, OpenSearchClient osClient, Consumer<HitsMetadata> searchHitsProcessor) throws IOException {
        searchRequest.scroll(Time.of(t -> t.time(SCROLL_KEEP_ALIVE_MS)));
        SearchResponse response = osClient.search(searchRequest.build(), clazz);
        ArrayList<Object> result = new ArrayList<Object>();
        String scrollId = response.scrollId();
        HitsMetadata hits = response.hits();
        while (hits.hits().size() != 0) {
            result.addAll(hits.hits().stream().map(m -> ((Hit)m).source()).toList());
            if (searchHitsProcessor != null) {
                searchHitsProcessor.accept(response.hits());
            }
            ScrollRequest.Builder scrollRequest = new ScrollRequest.Builder();
            scrollRequest.scrollId(scrollId);
            scrollRequest.scroll(Time.of(t -> t.time(SCROLL_KEEP_ALIVE_MS)));
            response = osClient.scroll(scrollRequest.build(), clazz);
            scrollId = response.scrollId();
            hits = response.hits();
        }
        OpenSearchUtil.clearScroll(scrollId, osClient);
        return result;
    }

    public static List<String> scrollIdsToList(SearchRequest.Builder request, OpenSearchClient osClient) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        Consumer<List<Hit>> collectIds = hits -> result.addAll(CollectionUtil.map((Collection)hits, SEARCH_HIT_ID_TO_STRING));
        OpenSearchUtil.scrollWith(request, osClient, collectIds, null, null);
        return result;
    }

    public static Map<String, String> scrollIdsWithIndexToMap(SearchRequest.Builder request, OpenSearchClient osClient) throws IOException {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        Consumer<List<Hit>> collectIds = hits -> result.putAll(hits.stream().collect(Collectors.toMap(Hit::id, Hit::index)));
        OpenSearchUtil.scrollWith(request, osClient, collectIds, null, null);
        return result;
    }

    public static void executeUpdate(OpenSearchClient osClient, UpdateRequest updateRequest) throws PersistenceException {
        try {
            osClient.update(updateRequest, Object.class);
        }
        catch (IOException | OpenSearchException e) {
            String errorMessage = String.format("Update request failed for [%s] and id [%s] with the message [%s].", updateRequest.index(), updateRequest.id(), e.getMessage());
            throw new PersistenceException(errorMessage, e);
        }
    }

    public static enum QueryType {
        ONLY_RUNTIME,
        ALL;

    }
}

