/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.store.opensearch;

import io.camunda.tasklist.data.conditionals.OpenSearchCondition;
import io.camunda.tasklist.entities.ProcessInstanceEntity;
import io.camunda.tasklist.enums.DeletionStatus;
import io.camunda.tasklist.os.RetryOpenSearchClient;
import io.camunda.tasklist.property.TasklistProperties;
import io.camunda.tasklist.schema.indices.ProcessInstanceDependant;
import io.camunda.tasklist.schema.indices.ProcessInstanceIndex;
import io.camunda.tasklist.schema.templates.TaskVariableTemplate;
import io.camunda.tasklist.store.ProcessInstanceStore;
import io.camunda.tasklist.store.TaskStore;
import io.camunda.tasklist.tenant.TenantAwareOpenSearchClient;
import io.camunda.tasklist.util.OpenSearchUtil;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.opensearch.client.opensearch._types.FieldValue;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.opensearch.client.opensearch.core.search.Hit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class ProcessInstanceStoreOpenSearch
implements ProcessInstanceStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessInstanceStoreOpenSearch.class);
    @Autowired
    ProcessInstanceIndex processInstanceIndex;
    @Autowired
    TaskStore taskStore;
    @Autowired
    List<ProcessInstanceDependant> processInstanceDependants;
    @Autowired
    TaskVariableTemplate taskVariableTemplate;
    @Autowired
    RetryOpenSearchClient retryOpenSearchClient;
    @Autowired
    TenantAwareOpenSearchClient tenantAwareClient;
    @Autowired
    TasklistProperties tasklistProperties;

    @Override
    public DeletionStatus deleteProcessInstance(String processInstanceId) {
        if (this.tasklistProperties.getMultiTenancy().isEnabled() && this.getById(processInstanceId).isEmpty()) {
            return DeletionStatus.NOT_FOUND;
        }
        boolean processInstanceWasDeleted = this.retryOpenSearchClient.deleteDocument(this.processInstanceIndex.getFullQualifiedName(), processInstanceId);
        if (processInstanceWasDeleted) {
            return this.deleteProcessInstanceDependantsFor(processInstanceId);
        }
        return DeletionStatus.NOT_FOUND;
    }

    private DeletionStatus deleteProcessInstanceDependantsFor(String processInstanceId) {
        List<String> dependantTaskIds = this.getDependantTasksIdsFor(processInstanceId);
        boolean deleted = false;
        for (ProcessInstanceDependant dependant : this.processInstanceDependants) {
            deleted = this.retryOpenSearchClient.deleteDocumentsByQuery(dependant.getAllIndicesPattern(), (Query)new Query.Builder().term(term -> term.field("processInstanceId").value(FieldValue.of((String)processInstanceId))).build()) || deleted;
        }
        if (deleted) {
            this.deleteVariablesFor(dependantTaskIds);
            return DeletionStatus.DELETED;
        }
        return DeletionStatus.FAILED;
    }

    private List<String> getDependantTasksIdsFor(String processInstanceId) {
        return this.taskStore.getTaskIdsByProcessInstanceId(processInstanceId);
    }

    private boolean deleteVariablesFor(List<String> taskIds) {
        return this.retryOpenSearchClient.deleteDocumentsByQuery(OpenSearchUtil.whereToSearch(this.taskVariableTemplate, OpenSearchUtil.QueryType.ALL), (Query)new Query.Builder().terms(terms -> terms.field("taskId").terms(v -> v.value(taskIds.stream().map(m -> FieldValue.of((String)m)).collect(Collectors.toList())))).build());
    }

    private Optional<ProcessInstanceEntity> getById(String variableId) {
        try {
            SearchRequest.Builder searchRequest = new SearchRequest.Builder();
            searchRequest.index(this.processInstanceIndex.getFullQualifiedName(), new String[0]);
            searchRequest.query(q -> q.term(term -> term.field("id").value(FieldValue.of((String)variableId))));
            SearchResponse searchResponse = this.tenantAwareClient.search(searchRequest, ProcessInstanceEntity.class);
            List hits = searchResponse.hits().hits();
            if (hits.size() == 0) {
                return Optional.empty();
            }
            Hit hit = (Hit)hits.get(0);
            return Optional.of((ProcessInstanceEntity)hit.source());
        }
        catch (IOException e) {
            LOGGER.error(String.format("Error retrieving processInstance with ID [%s]", variableId), (Throwable)e);
            return Optional.empty();
        }
    }
}

