/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.store.opensearch;

import io.camunda.tasklist.data.conditionals.OpenSearchCondition;
import io.camunda.tasklist.entities.FormEntity;
import io.camunda.tasklist.exceptions.NotFoundException;
import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import io.camunda.tasklist.schema.indices.FormIndex;
import io.camunda.tasklist.schema.indices.ProcessIndex;
import io.camunda.tasklist.schema.templates.TaskTemplate;
import io.camunda.tasklist.store.FormStore;
import io.camunda.tasklist.tenant.TenantAwareOpenSearchClient;
import io.camunda.tasklist.util.OpenSearchUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch._types.FieldValue;
import org.opensearch.client.opensearch._types.OpenSearchException;
import org.opensearch.client.opensearch._types.SortOrder;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.opensearch.client.opensearch.core.search.Hit;
import org.opensearch.client.util.ObjectBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class FormStoreOpenSearch
implements FormStore {
    @Autowired
    private FormIndex formIndex;
    @Autowired
    private TaskTemplate taskTemplate;
    @Autowired
    private ProcessIndex processIndex;
    @Autowired
    private TenantAwareOpenSearchClient tenantAwareClient;
    @Autowired
    @Qualifier(value="tasklistOsClient")
    private OpenSearchClient osClient;

    @Override
    public FormEntity getForm(String id, String processDefinitionId, Long version) {
        FormEntity formLinked;
        FormEntity formEmbedded;
        FormEntity formEntity = formEmbedded = version == null ? this.getFormEmbedded(id, processDefinitionId) : null;
        if (formEmbedded != null) {
            return formEmbedded;
        }
        if (this.isFormAssociatedToTask(id, processDefinitionId).booleanValue()) {
            FormEntity formLinked2 = this.getLinkedForm(id, version);
            if (formLinked2 != null) {
                return formLinked2;
            }
        } else if (this.isFormAssociatedToProcess(id, processDefinitionId).booleanValue() && (formLinked = this.getLinkedForm(id, version)) != null) {
            return formLinked;
        }
        throw new NotFoundException(String.format("form with id %s was not found", id));
    }

    private Boolean isFormAssociatedToTask(String formId, String processDefinitionId) {
        try {
            SearchRequest.Builder searchRequest = OpenSearchUtil.createSearchRequest(this.taskTemplate, OpenSearchUtil.QueryType.ALL).size(Integer.valueOf(1)).query(b -> b.bool(bool -> bool.must(must -> must.bool(boolIds -> boolIds.should(q1 -> q1.match(m -> m.field("formId").query(FieldValue.of((String)formId)))).should(q2 -> q2.match(m -> m.field("formKey").query(FieldValue.of((String)formId)))).minimumShouldMatch("1"))).must(q -> q.match(m -> m.field("processDefinitionId").query(FieldValue.of((String)processDefinitionId))))));
            SearchResponse searchResponse = this.tenantAwareClient.search(searchRequest, TaskTemplate.class);
            return searchResponse.hits().total().value() > 0L;
        }
        catch (IOException e) {
            String formIdNotFoundMessage = String.format("Error retrieving the association for the formId: [%s] and processDefinitionId: [%s]", formId, processDefinitionId);
            throw new TasklistRuntimeException(formIdNotFoundMessage);
        }
    }

    private Boolean isFormAssociatedToProcess(String formId, String processDefinitionId) {
        try {
            SearchRequest.Builder searchRequest = OpenSearchUtil.createSearchRequest(this.processIndex, OpenSearchUtil.QueryType.ALL).size(Integer.valueOf(1)).query(b -> b.bool(bool -> bool.must(q -> q.match(m -> m.field("formId").query(FieldValue.of((String)formId)))).must(q -> q.match(m -> m.field("id").query(FieldValue.of((String)processDefinitionId))))));
            SearchResponse searchResponse = this.tenantAwareClient.search(searchRequest, ProcessIndex.class);
            return searchResponse.hits().total().value() > 0L;
        }
        catch (IOException e) {
            String formIdNotFoundMessage = String.format("Error retrieving the association for the formId: [%s] and processDefinitionId: [%s]", formId, processDefinitionId);
            throw new TasklistRuntimeException(formIdNotFoundMessage);
        }
    }

    public FormEntity getLinkedForm(String formId, Long formVersion) {
        try {
            Query boolQuery;
            SearchRequest.Builder searchRequest = OpenSearchUtil.createSearchRequest(this.formIndex, OpenSearchUtil.QueryType.ALL).index(this.formIndex.getFullQualifiedName(), new String[0]).size(Integer.valueOf(1));
            Query.Builder bpmnIdProcessQ = new Query.Builder();
            bpmnIdProcessQ.bool(boolQ -> boolQ.should(q1 -> q1.terms(terms -> terms.field("bpmnId").terms(t -> t.value(Collections.singletonList(FieldValue.of((String)formId)))))).should(q2 -> q2.terms(terms -> terms.field("id").terms(t -> t.value(Collections.singletonList(FieldValue.of((String)formId)))))).minimumShouldMatch("1"));
            if (formVersion == null) {
                Query.Builder isDeleteQ = new Query.Builder();
                isDeleteQ.terms(terms -> terms.field("isDeleted").terms(t -> t.value(Collections.singletonList(FieldValue.of((boolean)false)))));
                boolQuery = OpenSearchUtil.joinWithAnd(new ObjectBuilder[]{bpmnIdProcessQ, isDeleteQ});
                searchRequest.sort(s -> s.field(f -> f.field("version").order(SortOrder.Desc)));
            } else {
                Query.Builder isVersionQ = new Query.Builder();
                isVersionQ.terms(terms -> terms.field("version").terms(t -> t.value(Collections.singletonList(FieldValue.of((long)formVersion)))));
                boolQuery = OpenSearchUtil.joinWithAnd(new ObjectBuilder[]{bpmnIdProcessQ, isVersionQ});
            }
            searchRequest.query(boolQuery);
            SearchResponse formEntityResponse = this.tenantAwareClient.search(searchRequest, FormEntity.class);
            if (!formEntityResponse.hits().hits().isEmpty()) {
                return (FormEntity)((Hit)formEntityResponse.hits().hits().get(0)).source();
            }
            return null;
        }
        catch (IOException e) {
            String formIdNotFoundMessage = String.format("Error retrieving the version for the formId: [%s]", formId);
            throw new TasklistRuntimeException(formIdNotFoundMessage);
        }
    }

    public FormEntity getFormEmbedded(String id, String processDefinitionId) {
        try {
            String formId = String.format("%s_%s", processDefinitionId, id);
            return OpenSearchUtil.getRawResponseWithTenantCheck(formId, this.formIndex, OpenSearchUtil.QueryType.ONLY_RUNTIME, this.tenantAwareClient, FormEntity.class);
        }
        catch (IOException | OpenSearchException e) {
            throw new TasklistRuntimeException(e.getMessage(), e);
        }
        catch (NotFoundException e) {
            return null;
        }
    }

    @Override
    public List<String> getFormIdsByProcessDefinitionId(String processDefinitionId) {
        SearchRequest.Builder searchRequest = OpenSearchUtil.createSearchRequest(this.formIndex, OpenSearchUtil.QueryType.ONLY_RUNTIME).query(q -> q.term(term -> term.field("processDefinitionId").value(FieldValue.of((String)processDefinitionId)))).fields(f -> f.field("id"));
        try {
            return OpenSearchUtil.scrollIdsToList(searchRequest, this.osClient);
        }
        catch (IOException e) {
            throw new TasklistRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Optional<FormStore.FormIdView> getHighestVersionFormByKey(String formKey) {
        try {
            SearchResponse formEntityResponse = this.osClient.search(b -> b.index(this.formIndex.getFullQualifiedName(), new String[0]).query(q -> q.term(t -> t.field("id").value(FieldValue.of((String)formKey)))).sort(s -> s.field(f -> f.field("version").order(SortOrder.Desc))).source(s -> s.filter(f -> f.includes(List.of("id", "bpmnId", "version")))).size(Integer.valueOf(1)), FormEntity.class);
            if (formEntityResponse.hits().total().value() == 1L) {
                FormEntity formEntity = (FormEntity)((Hit)formEntityResponse.hits().hits().get(0)).source();
                return Optional.of(new FormStore.FormIdView(formEntity.getId(), formEntity.getBpmnId(), formEntity.getVersion()));
            }
            return Optional.empty();
        }
        catch (IOException e) {
            throw new TasklistRuntimeException((Throwable)e);
        }
    }
}

