/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.store.opensearch;

import io.camunda.tasklist.CommonUtils;
import io.camunda.tasklist.data.conditionals.OpenSearchCondition;
import io.camunda.tasklist.entities.DraftTaskVariableEntity;
import io.camunda.tasklist.exceptions.PersistenceException;
import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import io.camunda.tasklist.schema.templates.DraftTaskVariableTemplate;
import io.camunda.tasklist.store.DraftVariableStore;
import io.camunda.tasklist.tenant.TenantAwareOpenSearchClient;
import io.camunda.tasklist.util.OpenSearchUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch._types.FieldValue;
import org.opensearch.client.opensearch._types.Refresh;
import org.opensearch.client.opensearch._types.query_dsl.BoolQuery;
import org.opensearch.client.opensearch.core.BulkRequest;
import org.opensearch.client.opensearch.core.DeleteByQueryRequest;
import org.opensearch.client.opensearch.core.DeleteByQueryResponse;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.opensearch.client.opensearch.core.bulk.BulkOperation;
import org.opensearch.client.opensearch.core.bulk.UpdateOperation;
import org.opensearch.client.opensearch.core.search.Hit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@Conditional(value={OpenSearchCondition.class})
public class DraftVariablesStoreOpenSearch
implements DraftVariableStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(DraftVariablesStoreOpenSearch.class);
    @Autowired
    @Qualifier(value="tasklistOsClient")
    private OpenSearchClient osClient;
    @Autowired
    private TenantAwareOpenSearchClient tenantAwareClient;
    @Autowired
    private DraftTaskVariableTemplate draftTaskVariableTemplate;

    @Override
    public void createOrUpdate(Collection<DraftTaskVariableEntity> draftVariables) {
        BulkRequest.Builder bulkRequest = new BulkRequest.Builder();
        List<BulkOperation> operations = draftVariables.stream().map(this::createUpsertRequest).toList();
        bulkRequest.operations(operations);
        bulkRequest.refresh(Refresh.WaitFor);
        try {
            OpenSearchUtil.processBulkRequest(this.osClient, bulkRequest.build());
        }
        catch (PersistenceException ex) {
            throw new TasklistRuntimeException((Throwable)ex);
        }
    }

    private BulkOperation createUpsertRequest(DraftTaskVariableEntity draftVariableEntity) {
        return (BulkOperation)new BulkOperation.Builder().update(UpdateOperation.of(u -> ((UpdateOperation.Builder)((UpdateOperation.Builder)u.index(this.draftTaskVariableTemplate.getFullQualifiedName())).id(draftVariableEntity.getId())).docAsUpsert(Boolean.valueOf(true)).document((Object)CommonUtils.getJsonObjectFromEntity((Object)draftVariableEntity)).retryOnConflict(Integer.valueOf(3)))).build();
    }

    @Override
    public long deleteAllByTaskId(String taskId) {
        DeleteByQueryRequest.Builder request = new DeleteByQueryRequest.Builder();
        request.index(this.draftTaskVariableTemplate.getFullQualifiedName(), new String[0]).query(q -> q.term(term -> term.field("taskId").value(FieldValue.of((String)taskId))));
        try {
            DeleteByQueryResponse response = this.osClient.deleteByQuery(request.build());
            return response.deleted();
        }
        catch (IOException e) {
            throw new TasklistRuntimeException(String.format("Error preparing the query to delete draft task variable instances for task [%s]", taskId), (Throwable)e);
        }
    }

    @Override
    public List<DraftTaskVariableEntity> getVariablesByTaskIdAndVariableNames(String taskId, List<String> variableNames) {
        try {
            BoolQuery.Builder queryBuilder = new BoolQuery.Builder();
            queryBuilder.must(q -> q.term(term -> term.field("taskId").value(FieldValue.of((String)taskId))));
            if (!CollectionUtils.isEmpty(variableNames)) {
                queryBuilder.must(q -> q.terms(terms -> terms.field("name").terms(v -> v.value(variableNames.stream().map(m -> FieldValue.of((String)m)).collect(Collectors.toList())))));
            }
            SearchRequest.Builder searchRequestBuilder = new SearchRequest.Builder().index(this.draftTaskVariableTemplate.getFullQualifiedName(), new String[0]).query(q -> q.bool(queryBuilder.build()));
            return OpenSearchUtil.scroll(searchRequestBuilder, DraftTaskVariableEntity.class, this.osClient);
        }
        catch (IOException e) {
            throw new TasklistRuntimeException(String.format("Error executing the query to get draft task variable instances for task [%s] with variable names %s", taskId, variableNames), (Throwable)e);
        }
    }

    @Override
    public Optional<DraftTaskVariableEntity> getById(String variableId) {
        try {
            SearchRequest.Builder searchRequest = new SearchRequest.Builder();
            searchRequest.index(this.draftTaskVariableTemplate.getFullQualifiedName(), new String[0]);
            searchRequest.query(q -> q.term(term -> term.field("id").value(FieldValue.of((String)variableId))));
            SearchResponse searchResponse = this.tenantAwareClient.search(searchRequest, DraftTaskVariableEntity.class);
            List hits = searchResponse.hits().hits();
            if (hits.size() == 0) {
                return Optional.empty();
            }
            Hit hit = (Hit)hits.get(0);
            return Optional.of((DraftTaskVariableEntity)hit.source());
        }
        catch (IOException e) {
            LOGGER.error(String.format("Error retrieving draft task variable instance with ID [%s]", variableId), (Throwable)e);
            return Optional.empty();
        }
    }

    @Override
    public List<String> getDraftVariablesIdsByTaskIds(List<String> taskIds) {
        SearchRequest.Builder searchRequest = new SearchRequest.Builder();
        searchRequest.index(this.draftTaskVariableTemplate.getFullQualifiedName(), new String[0]).query(q -> q.terms(terms -> terms.field("taskId").terms(t -> t.value(taskIds.stream().map(FieldValue::of).collect(Collectors.toList()))))).fields(f -> f.field("id"));
        try {
            return OpenSearchUtil.scrollIdsToList(searchRequest, this.osClient);
        }
        catch (IOException e) {
            throw new TasklistRuntimeException(e.getMessage(), (Throwable)e);
        }
    }
}

