/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.store.elasticsearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.tasklist.data.conditionals.ElasticSearchCondition;
import io.camunda.tasklist.entities.MetricEntity;
import io.camunda.tasklist.entities.TaskEntity;
import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import io.camunda.tasklist.schema.indices.MetricIndex;
import io.camunda.tasklist.store.TaskMetricsStore;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedStringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class TaskMetricsStoreElasticSearch
implements TaskMetricsStore {
    public static final String EVENT_TASK_COMPLETED_BY_ASSIGNEE = "task_completed_by_assignee";
    public static final String ASSIGNEE = "assignee";
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskMetricsStoreElasticSearch.class);
    @Autowired
    private MetricIndex index;
    @Autowired
    @Qualifier(value="tasklistEsClient")
    private RestHighLevelClient esClient;
    @Autowired
    @Qualifier(value="tasklistObjectMapper")
    private ObjectMapper objectMapper;

    @Override
    public void registerTaskCompleteEvent(TaskEntity task) {
        MetricEntity metric = this.createTaskCompleteEvent(task);
        boolean inserted = this.insert(metric);
        if (!inserted) {
            String message = "Wrong response status while logging event";
            LOGGER.error("Wrong response status while logging event");
            throw new TasklistRuntimeException("Wrong response status while logging event");
        }
    }

    private boolean insert(MetricEntity entity) {
        try {
            IndexRequest request = new IndexRequest(this.index.getFullQualifiedName()).id(entity.getId()).source(this.objectMapper.writeValueAsString((Object)entity), XContentType.JSON);
            IndexResponse response = this.esClient.index(request, RequestOptions.DEFAULT);
            return response.status() == RestStatus.CREATED;
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new TasklistRuntimeException("Error while trying to upsert entity: " + String.valueOf(entity));
        }
    }

    @Override
    public List<String> retrieveDistinctAssigneesBetweenDates(OffsetDateTime startTime, OffsetDateTime endTime) {
        BoolQueryBuilder rangeQuery = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termsQuery((String)"event", (String[])new String[]{EVENT_TASK_COMPLETED_BY_ASSIGNEE})).must((QueryBuilder)QueryBuilders.rangeQuery((String)"eventTime").gte((Object)startTime).lte((Object)endTime));
        TermsAggregationBuilder aggregation = ((TermsAggregationBuilder)AggregationBuilders.terms((String)ASSIGNEE).field("value")).size(Integer.MAX_VALUE);
        SearchSourceBuilder source = SearchSourceBuilder.searchSource().query((QueryBuilder)rangeQuery).aggregation((AggregationBuilder)aggregation);
        SearchRequest searchRequest = new SearchRequest(new String[]{this.index.getFullQualifiedName()}).indicesOptions(IndicesOptions.lenientExpandOpen()).source(source);
        try {
            Aggregations aggregations = this.esClient.search(searchRequest, RequestOptions.DEFAULT).getAggregations();
            if (aggregations == null) {
                throw new TasklistRuntimeException("Search with aggregation returned no aggregation");
            }
            Aggregation group = aggregations.get(ASSIGNEE);
            if (!(group instanceof ParsedStringTerms)) {
                throw new TasklistRuntimeException("Unexpected response for aggregations");
            }
            ParsedStringTerms terms = (ParsedStringTerms)group;
            List buckets = terms.getBuckets();
            return buckets.stream().map(it -> String.valueOf(it.getKey())).collect(Collectors.toList());
        }
        catch (IOException e) {
            LOGGER.error("Error while retrieving assigned users between dates from index: " + String.valueOf(this.index), (Throwable)e);
            String message = "Error while retrieving assigned users between dates";
            throw new TasklistRuntimeException("Error while retrieving assigned users between dates");
        }
    }

    private MetricEntity createTaskCompleteEvent(TaskEntity task) {
        return (MetricEntity)new MetricEntity().setEvent(EVENT_TASK_COMPLETED_BY_ASSIGNEE).setValue(task.getAssignee()).setEventTime(task.getCompletionTime()).setTenantId(task.getTenantId());
    }
}

