/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.store.elasticsearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.tasklist.data.conditionals.ElasticSearchCondition;
import io.camunda.tasklist.entities.ProcessInstanceEntity;
import io.camunda.tasklist.enums.DeletionStatus;
import io.camunda.tasklist.es.RetryElasticsearchClient;
import io.camunda.tasklist.property.TasklistProperties;
import io.camunda.tasklist.schema.indices.ProcessInstanceDependant;
import io.camunda.tasklist.schema.indices.ProcessInstanceIndex;
import io.camunda.tasklist.schema.templates.TaskVariableTemplate;
import io.camunda.tasklist.store.ProcessInstanceStore;
import io.camunda.tasklist.store.TaskStore;
import io.camunda.tasklist.tenant.TenantAwareElasticsearchClient;
import io.camunda.tasklist.util.ElasticsearchUtil;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class ProcessInstanceStoreElasticSearch
implements ProcessInstanceStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessInstanceStoreElasticSearch.class);
    @Autowired
    ProcessInstanceIndex processInstanceIndex;
    @Autowired
    TaskStore taskStore;
    @Autowired
    List<ProcessInstanceDependant> processInstanceDependants;
    @Autowired
    TaskVariableTemplate taskVariableTemplate;
    @Autowired
    RetryElasticsearchClient retryElasticsearchClient;
    @Autowired
    TenantAwareElasticsearchClient tenantAwareClient;
    @Autowired
    TasklistProperties tasklistProperties;
    @Autowired
    @Qualifier(value="tasklistObjectMapper")
    private ObjectMapper objectMapper;

    @Override
    public DeletionStatus deleteProcessInstance(String processInstanceId) {
        if (this.tasklistProperties.getMultiTenancy().isEnabled() && this.getById(processInstanceId).isEmpty()) {
            return DeletionStatus.NOT_FOUND;
        }
        boolean processInstanceWasDeleted = this.retryElasticsearchClient.deleteDocument(this.processInstanceIndex.getFullQualifiedName(), processInstanceId);
        if (processInstanceWasDeleted) {
            return this.deleteProcessInstanceDependantsFor(processInstanceId);
        }
        return DeletionStatus.NOT_FOUND;
    }

    private DeletionStatus deleteProcessInstanceDependantsFor(String processInstanceId) {
        List<String> dependantTaskIds = this.getDependantTasksIdsFor(processInstanceId);
        boolean deleted = false;
        for (ProcessInstanceDependant dependant : this.processInstanceDependants) {
            deleted = this.retryElasticsearchClient.deleteDocumentsByQuery(dependant.getAllIndicesPattern(), (QueryBuilder)QueryBuilders.termQuery((String)"processInstanceId", (String)processInstanceId)) || deleted;
        }
        if (deleted) {
            this.deleteVariablesFor(dependantTaskIds);
            return DeletionStatus.DELETED;
        }
        return DeletionStatus.FAILED;
    }

    private List<String> getDependantTasksIdsFor(String processInstanceId) {
        return this.taskStore.getTaskIdsByProcessInstanceId(processInstanceId);
    }

    private Optional<ProcessInstanceEntity> getById(String processInstanceId) {
        try {
            SearchRequest searchRequest = new SearchRequest(new String[]{this.processInstanceIndex.getFullQualifiedName()});
            SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
            sourceBuilder.query((QueryBuilder)QueryBuilders.termQuery((String)"id", (String)processInstanceId));
            searchRequest.source(sourceBuilder);
            SearchResponse searchResponse = this.tenantAwareClient.search(searchRequest);
            SearchHits hits = searchResponse.getHits();
            if (hits.getTotalHits().value == 0L) {
                return Optional.empty();
            }
            SearchHit hit = hits.getAt(0);
            String sourceAsString = hit.getSourceAsString();
            ProcessInstanceEntity entity = (ProcessInstanceEntity)this.objectMapper.readValue(sourceAsString, ProcessInstanceEntity.class);
            return Optional.of(entity);
        }
        catch (IOException e) {
            LOGGER.error(String.format("Error retrieving processInstance with ID [%s]", processInstanceId), (Throwable)e);
            return Optional.empty();
        }
    }

    private boolean deleteVariablesFor(List<String> taskIds) {
        return this.retryElasticsearchClient.deleteDocumentsByQuery(ElasticsearchUtil.whereToSearch(this.taskVariableTemplate, ElasticsearchUtil.QueryType.ALL), (QueryBuilder)QueryBuilders.termsQuery((String)"taskId", taskIds));
    }
}

