/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.schema.migration;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.camunda.tasklist.schema.SemanticVersion;
import io.camunda.tasklist.schema.migration.ProcessorStep;
import java.time.OffsetDateTime;
import java.util.Comparator;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME)
@JsonSubTypes(value={@JsonSubTypes.Type(value=ProcessorStep.class)})
public interface Step {
    public static final Comparator<Step> SEMANTICVERSION_COMPARATOR = Comparator.comparing(s -> SemanticVersion.fromVersion(s.getVersion()));
    public static final Comparator<Step> ORDER_COMPARATOR = Comparator.comparing(Step::getOrder);
    public static final Comparator<Step> SEMANTICVERSION_ORDER_COMPARATOR = (s1, s2) -> {
        int result = SEMANTICVERSION_COMPARATOR.compare((Step)s1, (Step)s2);
        if (result == 0) {
            result = ORDER_COMPARATOR.compare((Step)s1, (Step)s2);
        }
        return result;
    };
    public static final String INDEX_NAME = "indexName";
    public static final String CREATED_DATE = "createdDate";
    public static final String APPLIED = "applied";
    public static final String APPLIED_DATE = "appliedDate";
    public static final String VERSION = "version";
    public static final String ORDER = "order";
    public static final String CONTENT = "content";

    public OffsetDateTime getCreatedDate();

    public Step setCreatedDate(OffsetDateTime var1);

    public OffsetDateTime getAppliedDate();

    public Step setAppliedDate(OffsetDateTime var1);

    public String getVersion();

    public Integer getOrder();

    public boolean isApplied();

    public Step setApplied(boolean var1);

    public String getIndexName();

    public String getContent();

    public String getDescription();
}

