/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.zeebe;

import io.camunda.tasklist.property.TasklistProperties;
import io.camunda.tasklist.property.ZeebeProperties;
import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.ZeebeClientBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ZeebeConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZeebeConnector.class);
    private static final int JOB_WORKER_MAX_JOBS_ACTIVE = 5;
    @Autowired
    private TasklistProperties tasklistProperties;

    @Bean
    public ZeebeClient tasklistZeebeClient() {
        return this.newZeebeClient(this.tasklistProperties.getZeebe());
    }

    public ZeebeClient newZeebeClient(ZeebeProperties zeebeProperties) {
        LOGGER.info("Zeebe Client - Using REST Configuration: {}", (Object)this.getURIFromSaaSOrProperties(zeebeProperties.getRestAddress()));
        LOGGER.info("Zeebe Client - Using Gateway Configuration: {}", (Object)zeebeProperties.getGatewayAddress());
        ZeebeClientBuilder builder = ZeebeClient.newClientBuilder().gatewayAddress(zeebeProperties.getGatewayAddress()).restAddress(this.getURIFromSaaSOrProperties(zeebeProperties.getRestAddress())).defaultJobWorkerMaxJobsActive(5);
        if (zeebeProperties.isSecure()) {
            builder.caCertificatePath(zeebeProperties.getCertificatePath());
            LOGGER.info("Use TLS connection to zeebe");
        } else {
            builder.usePlaintext();
            LOGGER.info("Use plaintext connection to zeebe");
        }
        return builder.build();
    }

    private static URI getURIFromString(String uri) {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Failed to parse URI string", e);
        }
    }

    private URI getURIFromSaaSOrProperties(String uri) {
        try {
            if (this.tasklistProperties.getClient().getClusterId() != null) {
                return new URI("http://zeebe-service:8080/" + this.tasklistProperties.getClient().getClusterId());
            }
            return ZeebeConnector.getURIFromString(uri);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Failed to parse URI string", e);
        }
    }
}

