/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.util;

import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import java.util.function.Supplier;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.LazyInitializer;

public final class LazySupplier<T>
implements Supplier<T> {
    private final LazyInitializer<T> lazyInitializer;

    private LazySupplier(LazyInitializer<T> lazyInitializer) {
        this.lazyInitializer = lazyInitializer;
    }

    public static <T> LazySupplier<T> of(Supplier<T> supplier) {
        return new LazySupplier<T>(((LazyInitializer.Builder)LazyInitializer.builder().setInitializer(supplier::get)).get());
    }

    @Override
    public T get() {
        try {
            return (T)this.lazyInitializer.get();
        }
        catch (ConcurrentException e) {
            throw new TasklistRuntimeException(e);
        }
    }
}

