/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.util;

public class BackoffIdleStrategy {
    private static final int NOT_IDLE = 0;
    private static final int IDLE = 1;
    private final long baseIdleTime;
    private final float idleIncreaseFactor;
    private final long maxIdleTime;
    private final int maxIdles;
    private int state = 0;
    private int idles;

    public BackoffIdleStrategy(long baseIdleTime, float idleIncreaseFactor, long maxIdleTime) {
        this.baseIdleTime = baseIdleTime;
        this.idleIncreaseFactor = idleIncreaseFactor;
        this.maxIdleTime = maxIdleTime;
        this.maxIdles = (int)this.log(idleIncreaseFactor, maxIdleTime / baseIdleTime) + 1;
    }

    private double log(double base, double value) {
        return Math.log10(value) / Math.log10(base);
    }

    public void idle() {
        switch (this.state) {
            case 0: {
                this.state = 1;
                this.idles = 1;
                break;
            }
            default: {
                ++this.idles;
                this.idles = Math.min(this.idles, this.maxIdles);
            }
        }
    }

    public void reset() {
        this.idles = 0;
        this.state = 0;
    }

    public long idleTime() {
        return switch (this.state) {
            case 0 -> 0L;
            default -> {
                long t = (long)((double)this.baseIdleTime * Math.pow(this.idleIncreaseFactor, this.idles - 1));
                yield Math.min(this.maxIdleTime, t);
            }
        };
    }
}

