/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.queries;

import graphql.annotations.annotationTypes.GraphQLConstructor;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Date;
import java.util.Objects;
import java.util.StringJoiner;

public class DateFilter {
    @Schema(description="Start date range to search from in date-time format outlined in section 5.6 of the RFC 3339 profile of the ISO 8601 standard.")
    @GraphQLField
    @GraphQLNonNull
    private Date from;
    @Schema(description="End date range to search to in date-time format outlined in section 5.6 of the RFC 3339 profile of the ISO 8601 standard.")
    @GraphQLField
    @GraphQLNonNull
    private Date to;

    @GraphQLConstructor
    public DateFilter(Date from, Date to) {
        this.from = from;
        this.to = to;
    }

    public DateFilter() {
    }

    public Date getTo() {
        return this.to;
    }

    public DateFilter setTo(Date to) {
        this.to = to;
        return this;
    }

    public Date getFrom() {
        return this.from;
    }

    public DateFilter setFrom(Date from) {
        this.from = from;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DateFilter that = (DateFilter)o;
        return Objects.equals(this.from, that.from) && Objects.equals(this.to, that.to);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.to);
    }

    public String toString() {
        return new StringJoiner(", ", DateFilter.class.getSimpleName() + "[", "]").add("from=" + String.valueOf(this.from)).add("to=" + String.valueOf(this.to)).toString();
    }
}

