/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.entities.listview;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.camunda.tasklist.entities.VariableEntity;
import io.camunda.tasklist.entities.listview.ListViewJoinRelation;

public class VariableListViewEntity {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String id;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String name;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String value;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String fullValue;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Boolean isPreview;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String scopeKey;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Integer partitionId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String tenantId;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private ListViewJoinRelation join;

    public VariableListViewEntity() {
    }

    public VariableListViewEntity(VariableEntity entity) {
        this.setValue(entity.getValue());
        this.setFullValue(entity.getFullValue());
        this.setName(entity.getName());
        this.setIsPreview(entity.getIsPreview());
        this.setScopeKey(entity.getScopeFlowNodeId());
        this.setId(entity.getId());
        this.setPartitionId(entity.getPartitionId());
        this.setTenantId(entity.getTenantId());
        ListViewJoinRelation joinRelation = new ListViewJoinRelation();
        this.setJoin(joinRelation);
    }

    public String getId() {
        return this.id;
    }

    public VariableListViewEntity setId(String id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public VariableListViewEntity setName(String name) {
        this.name = name;
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public VariableListViewEntity setValue(String value) {
        this.value = value;
        return this;
    }

    public String getFullValue() {
        return this.fullValue;
    }

    public VariableListViewEntity setFullValue(String fullValue) {
        this.fullValue = fullValue;
        return this;
    }

    public Boolean getIsPreview() {
        return this.isPreview;
    }

    public VariableListViewEntity setIsPreview(Boolean isPreview) {
        this.isPreview = isPreview;
        return this;
    }

    public String getScopeKey() {
        return this.scopeKey;
    }

    public VariableListViewEntity setScopeKey(String scopeKey) {
        this.scopeKey = scopeKey;
        return this;
    }

    public Integer getPartitionId() {
        return this.partitionId;
    }

    public VariableListViewEntity setPartitionId(Integer partitionId) {
        this.partitionId = partitionId;
        return this;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public VariableListViewEntity setTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public ListViewJoinRelation getJoin() {
        return this.join;
    }

    public VariableListViewEntity setJoin(ListViewJoinRelation join) {
        this.join = join;
        return this;
    }

    public static VariableListViewEntity createFrom(String tenantId, String id, String name, String value, String scopeKey, int variableSizeThreshold, ListViewJoinRelation listViewJoinRelation) {
        VariableListViewEntity entity = new VariableListViewEntity().setId(id).setName(name);
        if (value.length() > variableSizeThreshold) {
            entity.setValue(value.substring(0, variableSizeThreshold));
            entity.setIsPreview(true);
        } else {
            entity.setIsPreview(false);
            entity.setValue(value);
        }
        entity.setScopeKey(scopeKey);
        entity.setFullValue(value);
        entity.setTenantId(tenantId);
        entity.setJoin(listViewJoinRelation);
        return entity;
    }
}

