/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.entities;

import io.camunda.tasklist.entities.DraftTaskVariableEntity;
import io.camunda.tasklist.entities.TasklistZeebeEntity;
import io.camunda.tasklist.entities.VariableEntity;
import java.util.Objects;

public class TaskVariableEntity
extends TasklistZeebeEntity<TaskVariableEntity> {
    private String taskId;
    private String name;
    private String value;
    private String fullValue;
    private boolean isPreview;

    public static String getIdBy(String taskId, String name) {
        return String.format("%s-%s", taskId, name);
    }

    public String getTaskId() {
        return this.taskId;
    }

    public TaskVariableEntity setTaskId(String taskId) {
        this.taskId = taskId;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public TaskVariableEntity setName(String name) {
        this.name = name;
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public TaskVariableEntity setValue(String value) {
        this.value = value;
        return this;
    }

    public String getFullValue() {
        return this.fullValue;
    }

    public TaskVariableEntity setFullValue(String fullValue) {
        this.fullValue = fullValue;
        return this;
    }

    public boolean getIsPreview() {
        return this.isPreview;
    }

    public TaskVariableEntity setIsPreview(boolean preview) {
        this.isPreview = preview;
        return this;
    }

    public static TaskVariableEntity createFrom(String tenantId, String taskId, String name, String value, int variableSizeThreshold) {
        TaskVariableEntity entity = ((TaskVariableEntity)new TaskVariableEntity().setId(TaskVariableEntity.getIdBy(taskId, name))).setTaskId(taskId).setName(name);
        if (value.length() > variableSizeThreshold) {
            entity.setValue(value.substring(0, variableSizeThreshold));
            entity.setIsPreview(true);
        } else {
            entity.setValue(value);
        }
        entity.setFullValue(value);
        entity.setTenantId(tenantId);
        return entity;
    }

    public static TaskVariableEntity createFrom(String taskId, VariableEntity variableEntity) {
        return (TaskVariableEntity)((TaskVariableEntity)new TaskVariableEntity().setId(TaskVariableEntity.getIdBy(taskId, variableEntity.getName()))).setTaskId(taskId).setName(variableEntity.getName()).setValue(variableEntity.getValue()).setIsPreview(variableEntity.getIsPreview()).setFullValue(variableEntity.getFullValue()).setTenantId(variableEntity.getTenantId());
    }

    public static TaskVariableEntity createFrom(String taskId, DraftTaskVariableEntity draftTaskVariableEntity) {
        return (TaskVariableEntity)((TaskVariableEntity)new TaskVariableEntity().setId(TaskVariableEntity.getIdBy(taskId, draftTaskVariableEntity.getName()))).setTaskId(taskId).setName(draftTaskVariableEntity.getName()).setValue(draftTaskVariableEntity.getValue()).setIsPreview(draftTaskVariableEntity.getIsPreview()).setFullValue(draftTaskVariableEntity.getFullValue()).setTenantId(draftTaskVariableEntity.getTenantId());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TaskVariableEntity that = (TaskVariableEntity)o;
        return this.isPreview == that.isPreview && Objects.equals(this.taskId, that.taskId) && Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value) && Objects.equals(this.fullValue, that.fullValue);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.taskId, this.name, this.value, this.fullValue, this.isPreview);
    }
}

