/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class Metrics {
    public static final String TASKLIST_NAMESPACE = "tasklist.";
    public static final String TIMER_NAME_QUERY = "tasklist.query";
    public static final String TIMER_NAME_IMPORT_QUERY = "tasklist.import.query";
    public static final String TIMER_NAME_IMPORT_INDEX_QUERY = "tasklist.import.index.query";
    public static final String TIMER_NAME_IMPORT_TIME = "tasklist.import.time";
    public static final String TIMER_NAME_IMPORT_JOB_SCHEDULED_TIME = "tasklist.import.job.scheduled";
    public static final String TIMER_NAME_IMPORT_POSITION_UPDATE = "tasklist.import.position.update";
    public static final String TIMER_NAME_ARCHIVER_QUERY = "tasklist.archiver.query";
    public static final String TIMER_NAME_ARCHIVER_REINDEX_QUERY = "tasklist.archiver.reindex.query";
    public static final String TIMER_NAME_ARCHIVER_DELETE_QUERY = "tasklist.archiver.delete.query";
    public static final String COUNTER_NAME_EVENTS_PROCESSED = "events.processed";
    public static final String COUNTER_NAME_EVENTS_PROCESSED_FINISHED_WI = "events.processed.finished.process.instances";
    public static final String COUNTER_NAME_COMMANDS = "commands";
    public static final String COUNTER_NAME_ARCHIVED = "archived.process.instances";
    public static final String COUNTER_NAME_CLAIMED_TASKS = "claimed.tasks";
    public static final String COUNTER_NAME_COMPLETED_TASKS = "completed.tasks";
    public static final String TAG_KEY_NAME = "name";
    public static final String TAG_KEY_TYPE = "type";
    public static final String TAG_KEY_PARTITION = "partition";
    public static final String TAG_KEY_STATUS = "status";
    public static final String TAG_KEY_BPMN_PROCESS_ID = "bpmnProcessId";
    public static final String TAG_KEY_FLOW_NODE_ID = "flowNodeId";
    public static final String TAG_KEY_USER_ID = "userId";
    public static final String TAG_KEY_ORGANIZATION_ID = "organizationId";
    public static final String TAG_VALUE_PROCESSINSTANCES = "processInstances";
    public static final String TAG_VALUE_CORESTATISTICS = "corestatistics";
    public static final String TAG_VALUE_SUCCEEDED = "succeeded";
    public static final String TAG_VALUE_FAILED = "failed";
    private static final Logger LOGGER = LoggerFactory.getLogger(Metrics.class);
    @Autowired
    private MeterRegistry registry;

    public void recordCounts(String name, long count, String ... tags) {
        this.registry.counter(TASKLIST_NAMESPACE + name, tags).increment((double)count);
    }

    public Timer getTimer(String name, String ... tags) {
        return this.registry.timer(name, tags);
    }
}

