/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.archiver.es;

import io.camunda.tasklist.Metrics;
import io.camunda.tasklist.archiver.AbstractArchiverJob;
import io.camunda.tasklist.archiver.ProcessInstanceArchiverJob;
import io.camunda.tasklist.archiver.es.AbstractArchiverJobElasticSearch;
import io.camunda.tasklist.data.conditionals.ElasticSearchCondition;
import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import io.camunda.tasklist.property.TasklistProperties;
import io.camunda.tasklist.schema.indices.FlowNodeInstanceIndex;
import io.camunda.tasklist.schema.indices.ProcessInstanceIndex;
import io.camunda.tasklist.schema.indices.VariableIndex;
import io.camunda.tasklist.util.Either;
import io.camunda.tasklist.util.ElasticsearchUtil;
import io.micrometer.core.instrument.Timer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.ConstantScoreQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@Conditional(value={ElasticSearchCondition.class})
public class ProcessInstanceArchiverJobElasticSearch
extends AbstractArchiverJobElasticSearch
implements ProcessInstanceArchiverJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessInstanceArchiverJobElasticSearch.class);
    @Autowired
    private FlowNodeInstanceIndex flowNodeInstanceIndex;
    @Autowired
    private VariableIndex variableIndex;
    @Autowired
    private ProcessInstanceIndex processInstanceIndex;
    @Autowired
    private TasklistProperties tasklistProperties;
    @Autowired
    @Qualifier(value="tasklistEsClient")
    private RestHighLevelClient esClient;
    @Autowired
    private Metrics metrics;

    public ProcessInstanceArchiverJobElasticSearch(List<Integer> partitionIds) {
        super(partitionIds);
    }

    @Override
    public CompletableFuture<Map.Entry<String, Integer>> archiveBatch(AbstractArchiverJob.ArchiveBatch archiveBatch) {
        CompletableFuture<Map.Entry<String, Integer>> archiveBatchFuture;
        if (archiveBatch != null) {
            LOGGER.debug("Following batch operations are found for archiving: {}", (Object)archiveBatch);
            archiveBatchFuture = new CompletableFuture();
            CompletableFuture<Long> deleteVariablesFuture = this.archiverUtil.deleteDocuments(this.variableIndex.getFullQualifiedName(), "processInstanceId", archiveBatch.getIds());
            CompletableFuture<Long> deleteFlowNodesFuture = this.archiverUtil.deleteDocuments(this.flowNodeInstanceIndex.getFullQualifiedName(), "processInstanceId", archiveBatch.getIds());
            CompletableFuture<Long> deleteProcessInstanceFuture = this.archiverUtil.deleteDocuments(this.processInstanceIndex.getFullQualifiedName(), "id", archiveBatch.getIds());
            ((CompletableFuture)CompletableFuture.allOf(deleteVariablesFuture, deleteFlowNodesFuture, deleteProcessInstanceFuture).thenAccept(v -> archiveBatchFuture.complete(Map.entry("PROCESS_INSTANCE_ARCHIVER", archiveBatch.getIds().size())))).exceptionally(t -> {
                archiveBatchFuture.completeExceptionally((Throwable)t);
                return null;
            });
        } else {
            LOGGER.debug("Nothing to archive");
            archiveBatchFuture = CompletableFuture.completedFuture(Map.entry("NothingToArchive", 0));
        }
        return archiveBatchFuture;
    }

    @Override
    public CompletableFuture<AbstractArchiverJob.ArchiveBatch> getNextBatch() {
        CompletableFuture<AbstractArchiverJob.ArchiveBatch> nextBatchFuture = new CompletableFuture<AbstractArchiverJob.ArchiveBatch>();
        SearchRequest searchRequest = this.createFinishedProcessInstanceSearchRequest();
        Timer.Sample startTimer = Timer.start();
        this.sendSearchRequest(searchRequest).whenComplete((response, e) -> {
            Timer timer = this.getArchiverQueryTimer();
            startTimer.stop(timer);
            Either<Throwable, AbstractArchiverJob.ArchiveBatch> result = this.handleSearchResponse((SearchResponse)response, (Throwable)e);
            result.ifRightOrLeft(nextBatchFuture::complete, nextBatchFuture::completeExceptionally);
        });
        return nextBatchFuture;
    }

    protected Either<Throwable, AbstractArchiverJob.ArchiveBatch> handleSearchResponse(SearchResponse searchResponse, Throwable error) {
        if (error != null) {
            String message = String.format("Exception occurred, while obtaining finished process instances: %s", error.getMessage());
            return Either.left((Object)new TasklistRuntimeException(message, error));
        }
        AbstractArchiverJob.ArchiveBatch batch = this.createArchiveBatch(searchResponse);
        return Either.right((Object)batch);
    }

    protected AbstractArchiverJob.ArchiveBatch createArchiveBatch(SearchResponse response) {
        SearchHits hits = response.getHits();
        if (hits.getHits().length > 0) {
            List<String> ids = Arrays.asList(hits.getHits()).stream().map(SearchHit::getId).collect(Collectors.toList());
            return new AbstractArchiverJob.ArchiveBatch(ids);
        }
        return null;
    }

    private SearchRequest createFinishedProcessInstanceSearchRequest() {
        RangeQueryBuilder endDateQ = QueryBuilders.rangeQuery((String)"endDate").lte((Object)this.tasklistProperties.getArchiver().getArchivingTimepoint());
        TermsQueryBuilder partitionQ = QueryBuilders.termsQuery((String)"partitionId", this.getPartitionIds());
        ConstantScoreQueryBuilder q = QueryBuilders.constantScoreQuery((QueryBuilder)ElasticsearchUtil.joinWithAnd((QueryBuilder[])new QueryBuilder[]{endDateQ, partitionQ}));
        SearchRequest searchRequest = new SearchRequest(new String[]{this.processInstanceIndex.getFullQualifiedName()}).source(new SearchSourceBuilder().query((QueryBuilder)q).fetchSource(false).size(this.tasklistProperties.getArchiver().getRolloverBatchSize()).sort("endDate", SortOrder.ASC)).requestCache(Boolean.valueOf(false));
        LOGGER.debug("Query finished process instances for archiving request: \n{}", (Object)q.toString());
        return searchRequest;
    }

    private Timer getArchiverQueryTimer() {
        return this.metrics.getTimer("tasklist.archiver.query", new String[0]);
    }
}

