/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.spring;

import io.camunda.operate.spring.OperateClientConfigurationProperties;
import java.util.List;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.env.YamlPropertySourceLoader;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class OperatePropertiesPostProcessor
implements EnvironmentPostProcessor {
    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        try {
            OperateClientConfigurationProperties.Profile profile = (OperateClientConfigurationProperties.Profile)((Object)environment.getProperty("operate.client.profile", OperateClientConfigurationProperties.Profile.class));
            if (profile == null) {
                return;
            }
            YamlPropertySourceLoader loader = new YamlPropertySourceLoader();
            String propertiesFile = "operate-profiles/" + this.determinePropertiesFile(profile);
            ClassPathResource resource = new ClassPathResource(propertiesFile);
            List props = loader.load(propertiesFile, (Resource)resource);
            for (PropertySource prop : props) {
                environment.getPropertySources().addLast(prop);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Error while post processing camunda properties", e);
        }
    }

    private String determinePropertiesFile(OperateClientConfigurationProperties.Profile clientMode) {
        switch (clientMode) {
            case oidc: {
                return "oidc.yaml";
            }
            case saas: {
                return "saas.yaml";
            }
            case simple: {
                return "simple.yaml";
            }
        }
        throw new IllegalStateException("Unknown client mode " + String.valueOf((Object)clientMode));
    }
}

