/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.spring;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.CamundaOperateClient;
import io.camunda.operate.CamundaOperateClientConfiguration;
import io.camunda.operate.auth.Authentication;
import io.camunda.operate.auth.JwtAuthentication;
import io.camunda.operate.auth.JwtCredential;
import io.camunda.operate.auth.SimpleAuthentication;
import io.camunda.operate.auth.SimpleCredential;
import io.camunda.operate.auth.TokenResponseMapper;
import io.camunda.operate.spring.ObjectMapperConfiguration;
import io.camunda.operate.spring.OperateClientConfigurationProperties;
import io.camunda.zeebe.spring.client.properties.CamundaClientProperties;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

@EnableConfigurationProperties(value={OperateClientConfigurationProperties.class, io.camunda.zeebe.spring.client.properties.OperateClientConfigurationProperties.class, CamundaClientProperties.class})
@ConditionalOnProperty(value={"operate.client.enabled"}, matchIfMissing=true)
@Import(value={ObjectMapperConfiguration.class})
public class OperateClientConfiguration {
    private final OperateClientConfigurationProperties properties;
    private final ObjectMapper objectMapper;

    @Autowired
    public OperateClientConfiguration(OperateClientConfigurationProperties properties, ObjectMapper objectMapper) {
        this.properties = properties;
        this.objectMapper = objectMapper;
    }

    @Bean
    @ConditionalOnMissingBean
    public CamundaOperateClient camundaOperateClient(CamundaOperateClientConfiguration configuration) {
        return new CamundaOperateClient(configuration);
    }

    @Bean
    @ConditionalOnMissingBean
    public CamundaOperateClientConfiguration operateClientConfiguration(Authentication authentication, @Qualifier(value="operateHttpClient") CloseableHttpClient operateHttpClient) {
        return new CamundaOperateClientConfiguration(authentication, this.properties.baseUrl(), this.objectMapper, operateHttpClient);
    }

    @Bean(value={"operateHttpClient"})
    @ConditionalOnMissingBean(name={"operateHttpClient"})
    public CloseableHttpClient operateHttpClient() {
        return HttpClients.createSystem();
    }

    @Bean
    @ConditionalOnMissingBean
    public Authentication operateAuthentication() {
        if (this.properties.profile() == null) {
            throw new IllegalStateException("'operate.client.profile' is required");
        }
        switch (this.properties.profile()) {
            case simple: {
                return new SimpleAuthentication(new SimpleCredential(this.properties.username(), this.properties.password(), this.properties.baseUrl(), this.properties.sessionTimeout()));
            }
            case oidc: 
            case saas: {
                return new JwtAuthentication(new JwtCredential(this.properties.clientId(), this.properties.clientSecret(), this.properties.audience(), this.properties.authUrl(), this.properties.scope()), (TokenResponseMapper)new TokenResponseMapper.JacksonTokenResponseMapper(this.objectMapper));
            }
        }
        throw new IllegalStateException("Unsupported profile: " + String.valueOf((Object)this.properties.profile()));
    }
}

