/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.spring;

import io.camunda.tasklist.spring.TasklistClientConfigurationProperties;
import java.io.IOException;
import java.util.List;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.env.YamlPropertySourceLoader;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class TasklistPropertiesPostProcessor
implements EnvironmentPostProcessor {
    private final YamlPropertySourceLoader loader = new YamlPropertySourceLoader();

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        try {
            TasklistClientConfigurationProperties.Profile profile = (TasklistClientConfigurationProperties.Profile)((Object)environment.getProperty("tasklist.client.profile", TasklistClientConfigurationProperties.Profile.class));
            if (profile == null) {
                return;
            }
            this.loadProperties("tasklist-profiles/" + this.determinePropertiesFile(profile), environment);
            this.loadProperties("tasklist-profiles/defaults.yaml", environment);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error while post processing camunda properties", e);
        }
    }

    private void loadProperties(String propertiesFile, ConfigurableEnvironment environment) throws IOException {
        ClassPathResource resource = new ClassPathResource(propertiesFile);
        List props = this.loader.load(propertiesFile, (Resource)resource);
        for (PropertySource prop : props) {
            environment.getPropertySources().addLast(prop);
        }
    }

    private String determinePropertiesFile(TasklistClientConfigurationProperties.Profile clientMode) {
        switch (clientMode) {
            case oidc: {
                return "oidc.yaml";
            }
            case saas: {
                return "saas.yaml";
            }
            case simple: {
                return "simple.yaml";
            }
        }
        throw new IllegalStateException("Unknown client mode " + String.valueOf((Object)clientMode));
    }
}

