/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.security.sso;

import com.auth0.AuthenticationController;
import com.auth0.IdentityVerificationException;
import com.auth0.Tokens;
import io.camunda.identity.sdk.Identity;
import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.util.RetryOperation;
import io.camunda.operate.webapp.security.Permission;
import io.camunda.operate.webapp.security.sso.Auth0ServiceException;
import io.camunda.operate.webapp.security.sso.TokenAuthentication;
import io.camunda.operate.webapp.security.sso.model.ClusterInfo;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
@Profile(value={"sso-auth"})
public class Auth0Service {
    private static final String LOGOUT_URL_TEMPLATE = "https://%s/v2/logout?client_id=%s&returnTo=%s";
    private static final String PERMISSION_URL_TEMPLATE = "%s/%s";
    private static final List<String> SCOPES = List.of("openid", "profile", "email", "offline_access");
    @Autowired
    private BeanFactory beanFactory;
    @Autowired
    private AuthenticationController authenticationController;
    @Value(value="${camunda.operate.auth0.domain}")
    private String domain;
    @Value(value="${camunda.operate.auth0.clientId}")
    private String clientId;
    @Autowired
    private OperateProperties operateProperties;
    @Autowired(required=false)
    @Qualifier(value="saasIdentity")
    private Identity identity;
    @Autowired
    @Qualifier(value="auth0_restTemplate")
    private RestTemplate restTemplate;

    public Authentication authenticate(HttpServletRequest req, HttpServletResponse res) throws Auth0ServiceException {
        try {
            Tokens tokens = this.retrieveTokens(req, res);
            TokenAuthentication authentication = new TokenAuthentication(this.operateProperties.getAuth0(), this.operateProperties.getCloud().getOrganizationId());
            authentication.authenticate(tokens.getIdToken(), tokens.getRefreshToken(), tokens.getAccessToken());
            this.checkPermission(authentication, tokens.getAccessToken());
            authentication.getAuthorizations();
            return authentication;
        }
        catch (Exception e) {
            throw new Auth0ServiceException(e);
        }
    }

    private void checkPermission(TokenAuthentication authentication, String accessToken) {
        ClusterInfo.Permission operatePermissions;
        HttpHeaders headers = new HttpHeaders();
        headers.setBearerAuth(accessToken);
        String urlDomain = this.operateProperties.getCloud().getPermissionUrl();
        String url = String.format(PERMISSION_URL_TEMPLATE, urlDomain, this.operateProperties.getCloud().getOrganizationId());
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)headers), ClusterInfo.class, new Object[0]);
        ClusterInfo clusterInfo = (ClusterInfo)responseEntity.getBody();
        if (clusterInfo.getSalesPlan() != null) {
            authentication.setSalesPlanType(clusterInfo.getSalesPlan().getType());
        }
        if (!(operatePermissions = clusterInfo.getPermissions().getCluster().getOperate()).getRead().booleanValue()) {
            throw new InsufficientAuthenticationException("User doesn't have read access");
        }
        authentication.addPermission(Permission.READ);
        if (operatePermissions.getDelete().booleanValue() && operatePermissions.getCreate().booleanValue() && operatePermissions.getUpdate().booleanValue()) {
            authentication.addPermission(Permission.WRITE);
        }
    }

    public String getAuthorizeUrl(HttpServletRequest req, HttpServletResponse res) {
        return this.authenticationController.buildAuthorizeUrl(req, res, this.getRedirectURI(req, "/sso-callback", true)).withAudience(this.operateProperties.getCloud().getPermissionAudience()).withScope(String.join((CharSequence)" ", SCOPES)).build();
    }

    public String getLogoutUrlFor(String returnTo) {
        return String.format(LOGOUT_URL_TEMPLATE, this.domain, this.clientId, returnTo);
    }

    public Tokens retrieveTokens(HttpServletRequest req, HttpServletResponse res) throws Exception {
        return (Tokens)RetryOperation.newBuilder().noOfRetry(10).delayInterval(500, TimeUnit.MILLISECONDS).retryOn(new Class[]{IdentityVerificationException.class}).retryConsumer(() -> this.authenticationController.handle(req, res)).message("Auth0Service#retrieveTokens").build().retry();
    }

    public String getRedirectURI(HttpServletRequest req, String redirectTo) {
        return this.getRedirectURI(req, redirectTo, false);
    }

    public String getRedirectURI(HttpServletRequest req, String redirectTo, boolean omitContextPath) {
        String redirectUri = req.getScheme() + "://" + req.getServerName();
        if (req.getScheme().equals("http") && req.getServerPort() != 80 || req.getScheme().equals("https") && req.getServerPort() != 443) {
            redirectUri = redirectUri + ":" + req.getServerPort();
        }
        String clusterId = req.getContextPath().replace("/", "");
        if (omitContextPath) {
            return redirectUri + redirectTo + "?uuid=" + clusterId;
        }
        return redirectUri + req.getContextPath() + redirectTo;
    }
}

