/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.rest.validation;

import io.camunda.operate.util.CollectionUtil;
import io.camunda.operate.webapp.rest.dto.ListenerRequestDto;
import io.camunda.operate.webapp.rest.dto.VariableRequestDto;
import io.camunda.operate.webapp.rest.dto.listview.ListViewQueryDto;
import io.camunda.operate.webapp.rest.dto.metadata.FlowNodeMetadataRequestDto;
import io.camunda.operate.webapp.rest.dto.operation.CreateBatchOperationRequestDto;
import io.camunda.operate.webapp.rest.dto.operation.CreateOperationRequestDto;
import io.camunda.operate.webapp.rest.exception.InvalidRequestException;
import io.camunda.operate.webapp.rest.validation.CreateBatchOperationRequestValidator;
import io.camunda.operate.webapp.rest.validation.CreateRequestOperationValidator;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class ProcessInstanceRequestValidator {
    private final CreateBatchOperationRequestValidator createBatchOperationRequestValidator;
    private final CreateRequestOperationValidator createRequestOperationValidator;

    public ProcessInstanceRequestValidator(@NotNull CreateRequestOperationValidator createRequestOperationValidator, @NotNull CreateBatchOperationRequestValidator createBatchOperationRequestValidator) {
        this.createRequestOperationValidator = createRequestOperationValidator;
        this.createBatchOperationRequestValidator = createBatchOperationRequestValidator;
    }

    public void validateFlowNodeStatisticsRequest(ListViewQueryDto request) {
        List processDefinitionKeys = CollectionUtil.toSafeListOfLongs(request.getProcessIds());
        if ((processDefinitionKeys != null && processDefinitionKeys.size() == 1) == (request.getBpmnProcessId() != null && request.getProcessVersion() != null)) {
            throw new InvalidRequestException("Exactly one process must be specified in the request (via processIds or bpmnProcessId/version).");
        }
    }

    public void validateFlowNodeMetadataRequest(FlowNodeMetadataRequestDto request) {
        if (request.getFlowNodeId() == null && request.getFlowNodeType() == null && request.getFlowNodeInstanceId() == null) {
            throw new InvalidRequestException("At least flowNodeId or flowNodeInstanceId must be specified in the request.");
        }
        if (request.getFlowNodeId() != null && request.getFlowNodeInstanceId() != null) {
            throw new InvalidRequestException("Only one of flowNodeId or flowNodeInstanceId must be specified in the request.");
        }
    }

    public void validateVariableRequest(VariableRequestDto request) {
        if (request.getScopeId() == null) {
            throw new InvalidRequestException("ScopeId must be specified in the request.");
        }
    }

    public void validateListenerRequest(ListenerRequestDto request) {
        if (request.getPageSize() == null || request.getFlowNodeId() == null) {
            throw new InvalidRequestException("'pageSize' and 'flowNodeId' must be specified in the request.");
        }
    }

    public void validateCreateBatchOperationRequest(CreateBatchOperationRequestDto batchOperationRequest) {
        this.createBatchOperationRequestValidator.validate(batchOperationRequest);
    }

    public void validateCreateOperationRequest(CreateOperationRequestDto operationRequest, String processInstanceId) {
        this.createRequestOperationValidator.validate(operationRequest, processInstanceId);
    }
}

