/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.rest.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.webapp.rest.dto.SortingDto;
import io.camunda.operate.webapp.rest.dto.listview.SortValuesWrapper;
import io.camunda.operate.webapp.rest.exception.InvalidRequestException;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PaginatedQuery<T extends PaginatedQuery<T>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PaginatedQuery.class);
    private static final int DEFAULT_PAGE_SIZE = 50;
    protected Integer pageSize = 50;
    private SortingDto sorting;
    private SortValuesWrapper[] searchAfter;
    private SortValuesWrapper[] searchAfterOrEqual;
    private SortValuesWrapper[] searchBefore;
    private SortValuesWrapper[] searchBeforeOrEqual;

    public SortingDto getSorting() {
        return this.sorting;
    }

    public T setSorting(SortingDto sorting) {
        if (sorting != null && !this.getValidSortByValues().contains(sorting.getSortBy())) {
            throw new InvalidRequestException("SortBy parameter has invalid value: " + sorting.getSortBy());
        }
        this.sorting = sorting;
        return (T)this;
    }

    @JsonIgnore
    protected Set<String> getValidSortByValues() {
        return new HashSet<String>();
    }

    @Schema(description="Array of values (can be one): copy/paste of sortValues field from one of the objects.", example="[1605160098477, 4629710542312628000]")
    public SortValuesWrapper[] getSearchAfter() {
        return this.searchAfter;
    }

    public T setSearchAfter(SortValuesWrapper[] searchAfter) {
        this.searchAfter = searchAfter;
        return (T)this;
    }

    public Object[] getSearchAfter(ObjectMapper objectMapper) {
        return SortValuesWrapper.convertSortValues(this.searchAfter, objectMapper);
    }

    public SortValuesWrapper[] getSearchAfterOrEqual() {
        return this.searchAfterOrEqual;
    }

    public T setSearchAfterOrEqual(SortValuesWrapper[] searchAfterOrEqual) {
        this.searchAfterOrEqual = searchAfterOrEqual;
        return (T)this;
    }

    public Object[] getSearchAfterOrEqual(ObjectMapper objectMapper) {
        return SortValuesWrapper.convertSortValues(this.searchAfterOrEqual, objectMapper);
    }

    @Schema(description="Array of values (can be one): copy/paste of sortValues field from one of the objects.", example="[1605160098477, 4629710542312628000]")
    public SortValuesWrapper[] getSearchBefore() {
        return this.searchBefore;
    }

    public T setSearchBefore(SortValuesWrapper[] searchBefore) {
        this.searchBefore = searchBefore;
        return (T)this;
    }

    public Object[] getSearchBefore(ObjectMapper objectMapper) {
        return SortValuesWrapper.convertSortValues(this.searchBefore, objectMapper);
    }

    public SortValuesWrapper[] getSearchBeforeOrEqual() {
        return this.searchBeforeOrEqual;
    }

    public T setSearchBeforeOrEqual(SortValuesWrapper[] searchBeforeOrEqual) {
        this.searchBeforeOrEqual = searchBeforeOrEqual;
        return (T)this;
    }

    public Object[] getSearchBeforeOrEqual(ObjectMapper objectMapper) {
        return SortValuesWrapper.convertSortValues(this.searchBeforeOrEqual, objectMapper);
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public T setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return (T)this;
    }

    public int hashCode() {
        int result = Objects.hash(this.sorting, this.pageSize);
        result = 31 * result + Arrays.hashCode(this.searchAfter);
        result = 31 * result + Arrays.hashCode(this.searchAfterOrEqual);
        result = 31 * result + Arrays.hashCode(this.searchBefore);
        result = 31 * result + Arrays.hashCode(this.searchBeforeOrEqual);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaginatedQuery that = (PaginatedQuery)o;
        return Objects.equals(this.sorting, that.sorting) && Arrays.equals(this.searchAfter, that.searchAfter) && Arrays.equals(this.searchAfterOrEqual, that.searchAfterOrEqual) && Arrays.equals(this.searchBefore, that.searchBefore) && Arrays.equals(this.searchBeforeOrEqual, that.searchBeforeOrEqual) && Objects.equals(this.pageSize, that.pageSize);
    }
}

