/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.opensearch.reader;

import io.camunda.operate.conditions.OpensearchCondition;
import io.camunda.operate.entities.BatchOperationEntity;
import io.camunda.operate.entities.OperationEntity;
import io.camunda.operate.entities.OperationState;
import io.camunda.operate.entities.OperationType;
import io.camunda.operate.schema.templates.BatchOperationTemplate;
import io.camunda.operate.schema.templates.OperationTemplate;
import io.camunda.operate.schema.templates.TemplateDescriptor;
import io.camunda.operate.store.opensearch.dsl.AggregationDSL;
import io.camunda.operate.store.opensearch.dsl.QueryDSL;
import io.camunda.operate.store.opensearch.dsl.RequestDSL;
import io.camunda.operate.util.CollectionUtil;
import io.camunda.operate.webapp.opensearch.reader.OpensearchAbstractReader;
import io.camunda.operate.webapp.reader.OperationReader;
import io.camunda.operate.webapp.rest.dto.DtoCreator;
import io.camunda.operate.webapp.rest.dto.OperationDto;
import io.camunda.operate.webapp.security.UserService;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.client.opensearch._types.SortOptions;
import org.opensearch.client.opensearch._types.SortOrder;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={OpensearchCondition.class})
@Component
public class OpensearchOperationReader
extends OpensearchAbstractReader
implements OperationReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpensearchOperationReader.class);
    private static final String SCHEDULED_OPERATION = OperationState.SCHEDULED.toString();
    private static final String LOCKED_OPERATION = OperationState.LOCKED.toString();
    @Autowired
    private OperationTemplate operationTemplate;
    @Autowired
    private BatchOperationTemplate batchOperationTemplate;
    @Autowired
    private DateTimeFormatter dateTimeFormatter;
    @Autowired
    private UserService userService;

    private Query usernameQuery() {
        return QueryDSL.term((String)"username", (String)this.userService.getCurrentUser().getUsername());
    }

    @Override
    public List<OperationEntity> acquireOperations(int batchSize) {
        Query query = QueryDSL.constantScore((Query)QueryDSL.or((Query[])new Query[]{QueryDSL.term((String)"state", (String)SCHEDULED_OPERATION), QueryDSL.and((Query[])new Query[]{QueryDSL.term((String)"state", (String)LOCKED_OPERATION), QueryDSL.lte((String)"lockExpirationTime", (Object)this.dateTimeFormatter.format(OffsetDateTime.now()))})}));
        SearchRequest.Builder searchRequestBuilder = RequestDSL.searchRequestBuilder((TemplateDescriptor)this.operationTemplate, (RequestDSL.QueryType)RequestDSL.QueryType.ONLY_RUNTIME).sort(QueryDSL.sortOptions((String)"batchOperationId", (SortOrder)SortOrder.Asc), new SortOptions[0]).from(Integer.valueOf(0)).size(Integer.valueOf(batchSize)).query(query);
        return this.richOpenSearchClient.doc().searchValues(searchRequestBuilder, OperationEntity.class);
    }

    @Override
    public Map<Long, List<OperationEntity>> getOperationsPerProcessInstanceKey(List<Long> processInstanceKeys) {
        HashMap<Long, List<OperationEntity>> result = new HashMap<Long, List<OperationEntity>>();
        Query query = QueryDSL.constantScore((Query)QueryDSL.and((Query[])new Query[]{QueryDSL.longTerms((String)"processInstanceKey", processInstanceKeys), this.usernameQuery()}));
        SearchRequest.Builder searchRequestBuilder = RequestDSL.searchRequestBuilder((TemplateDescriptor)this.operationTemplate, (RequestDSL.QueryType)RequestDSL.QueryType.ALL).query(query).sort(QueryDSL.sortOptions((String)"processInstanceKey", (SortOrder)SortOrder.Asc), new SortOptions[]{QueryDSL.sortOptions((String)"id", (SortOrder)SortOrder.Asc)});
        this.richOpenSearchClient.doc().scrollValues(searchRequestBuilder, OperationEntity.class, true).forEach(operationEntity -> CollectionUtil.addToMap((Map)result, (Object)operationEntity.getProcessInstanceKey(), (Object)operationEntity));
        return result;
    }

    @Override
    public Map<Long, List<OperationEntity>> getOperationsPerIncidentKey(String processInstanceId) {
        HashMap<Long, List<OperationEntity>> result = new HashMap<Long, List<OperationEntity>>();
        Query query = QueryDSL.constantScore((Query)QueryDSL.and((Query[])new Query[]{QueryDSL.term((String)"processInstanceKey", (String)processInstanceId), this.usernameQuery()}));
        SearchRequest.Builder searchRequestBuilder = RequestDSL.searchRequestBuilder((TemplateDescriptor)this.operationTemplate, (RequestDSL.QueryType)RequestDSL.QueryType.ONLY_RUNTIME).query(query).sort(QueryDSL.sortOptions((String)"incidentKey", (SortOrder)SortOrder.Asc), new SortOptions[]{QueryDSL.sortOptions((String)"id", (SortOrder)SortOrder.Asc)});
        this.richOpenSearchClient.doc().scrollValues(searchRequestBuilder, OperationEntity.class).forEach(operationEntity -> CollectionUtil.addToMap((Map)result, (Object)operationEntity.getIncidentKey(), (Object)operationEntity));
        return result;
    }

    @Override
    public Map<String, List<OperationEntity>> getUpdateOperationsPerVariableName(Long processInstanceKey, Long scopeKey) {
        HashMap<String, List<OperationEntity>> result = new HashMap<String, List<OperationEntity>>();
        Query query = QueryDSL.constantScore((Query)QueryDSL.and((Query[])new Query[]{QueryDSL.term((String)"processInstanceKey", (Long)processInstanceKey), QueryDSL.term((String)"scopeKey", (Long)scopeKey), QueryDSL.term((String)"type", (String)OperationType.UPDATE_VARIABLE.name()), this.usernameQuery()}));
        SearchRequest.Builder searchRequestBuilder = RequestDSL.searchRequestBuilder((TemplateDescriptor)this.operationTemplate, (RequestDSL.QueryType)RequestDSL.QueryType.ALL).query(query).sort(QueryDSL.sortOptions((String)"id", (SortOrder)SortOrder.Asc), new SortOptions[0]);
        this.richOpenSearchClient.doc().scrollValues(searchRequestBuilder, OperationEntity.class).forEach(operationEntity -> CollectionUtil.addToMap((Map)result, (Object)operationEntity.getVariableName(), (Object)operationEntity));
        return result;
    }

    @Override
    public List<OperationEntity> getOperationsByProcessInstanceKey(Long processInstanceKey) {
        Query query = QueryDSL.constantScore((Query)QueryDSL.and((Query[])new Query[]{processInstanceKey == null ? null : QueryDSL.term((String)"processInstanceKey", (Long)processInstanceKey), this.usernameQuery()}));
        SearchRequest.Builder searchRequestBuilder = RequestDSL.searchRequestBuilder((TemplateDescriptor)this.operationTemplate, (RequestDSL.QueryType)RequestDSL.QueryType.ALL).query(query).sort(QueryDSL.sortOptions((String)"id", (SortOrder)SortOrder.Asc), new SortOptions[0]);
        return this.richOpenSearchClient.doc().scrollValues(searchRequestBuilder, OperationEntity.class);
    }

    @Override
    public List<BatchOperationEntity> getBatchOperations(int pageSize) {
        Query query = QueryDSL.constantScore((Query)QueryDSL.term((String)"username", (String)this.userService.getCurrentUser().getUsername()));
        SearchRequest.Builder searchRequestBuilder = RequestDSL.searchRequestBuilder((TemplateDescriptor)this.batchOperationTemplate, (RequestDSL.QueryType)RequestDSL.QueryType.ALL).query(query).size(Integer.valueOf(pageSize));
        return this.richOpenSearchClient.doc().searchValues(searchRequestBuilder, BatchOperationEntity.class);
    }

    @Override
    public List<OperationDto> getOperationsByBatchOperationId(String batchOperationId) {
        SearchRequest.Builder searchRequestBuilder = RequestDSL.searchRequestBuilder((TemplateDescriptor)this.operationTemplate, (RequestDSL.QueryType)RequestDSL.QueryType.ALL).query(QueryDSL.term((String)"batchOperationId", (String)batchOperationId));
        List operationEntities = this.richOpenSearchClient.doc().scrollValues(searchRequestBuilder, OperationEntity.class);
        return DtoCreator.create(operationEntities, OperationDto.class);
    }

    @Override
    public List<OperationDto> getOperations(OperationType operationType, String processInstanceId, String scopeId, String variableName) {
        SearchRequest.Builder searchRequestBuilder = RequestDSL.searchRequestBuilder((TemplateDescriptor)this.operationTemplate, (RequestDSL.QueryType)RequestDSL.QueryType.ALL).query(QueryDSL.and((Query[])new Query[]{QueryDSL.term((String)"type", (String)operationType.name()), QueryDSL.term((String)"processInstanceKey", (String)processInstanceId), QueryDSL.term((String)"scopeKey", (String)scopeId), QueryDSL.term((String)"variableName", (String)variableName)}));
        List operationEntities = this.richOpenSearchClient.doc().scrollValues(searchRequestBuilder, OperationEntity.class);
        return DtoCreator.create(operationEntities, OperationDto.class);
    }

    public SearchRequest.Builder getSearchRequestByIdWithMetadata(String batchOperationId) {
        Query failedOperationQuery = QueryDSL.term((String)"state", (String)OperationState.FAILED.name());
        Query completedOperationQuery = QueryDSL.term((String)"state", (String)OperationState.COMPLETED.name());
        SearchRequest.Builder searchRequestBuilder = RequestDSL.searchRequestBuilder((TemplateDescriptor)this.operationTemplate, (RequestDSL.QueryType)RequestDSL.QueryType.ALL).query(QueryDSL.term((String)"batchOperationId", (String)batchOperationId)).aggregations("metadataAggregation", AggregationDSL.filtersAggregation(Map.of("failedOperationsCount", failedOperationQuery, "completedOperationsCount", completedOperationQuery))._toAggregation());
        return searchRequestBuilder;
    }
}

