/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.elasticsearch.transform;

import io.camunda.operate.conditions.ElasticsearchCondition;
import io.camunda.operate.entities.OperationState;
import io.camunda.operate.webapp.elasticsearch.reader.OperationReader;
import io.camunda.operate.webapp.rest.dto.operation.BatchOperationDto;
import io.camunda.operate.webapp.transform.DataAggregator;
import java.util.List;
import java.util.Map;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.filter.FiltersAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.filter.FiltersAggregator;
import org.elasticsearch.search.aggregations.bucket.filter.ParsedFilters;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={ElasticsearchCondition.class})
@Component
public class ElasticsearchDataAggregator
extends DataAggregator {
    @Autowired
    private OperationReader operationReader;

    @Override
    public Map<String, BatchOperationDto> requestAndAddMetadata(Map<String, BatchOperationDto> resultDtos, List<String> idList) {
        FiltersAggregationBuilder metadataAggregation = AggregationBuilders.filters((String)"metadataAggregation", (FiltersAggregator.KeyedFilter[])new FiltersAggregator.KeyedFilter[]{new FiltersAggregator.KeyedFilter("failedOperationsCount", (QueryBuilder)QueryBuilders.termQuery((String)"state", (Object)OperationState.FAILED)), new FiltersAggregator.KeyedFilter("completedOperationsCount", (QueryBuilder)QueryBuilders.termQuery((String)"state", (Object)OperationState.COMPLETED))});
        Terms batchIdAggregation = this.operationReader.getOperationsAggregatedByBatchOperationId(idList, (AggregationBuilder)metadataAggregation);
        for (Terms.Bucket bucket : batchIdAggregation.getBuckets()) {
            ParsedFilters aggregations = (ParsedFilters)bucket.getAggregations().get("metadataAggregation");
            int failedCount = (int)aggregations.getBucketByKey("failedOperationsCount").getDocCount();
            int completedCount = (int)aggregations.getBucketByKey("completedOperationsCount").getDocCount();
            String batchId = bucket.getKeyAsString();
            resultDtos.get(batchId).setFailedOperationsCount(failedCount).setCompletedOperationsCount(completedCount);
        }
        return resultDtos;
    }
}

