/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.util;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.entities.HitEntity;
import io.camunda.operate.exceptions.ArchiverException;
import io.camunda.operate.exceptions.OperateRuntimeException;
import io.camunda.operate.exceptions.PersistenceException;
import io.camunda.operate.schema.templates.AbstractTemplateDescriptor;
import io.camunda.operate.schema.templates.TemplateDescriptor;
import io.camunda.operate.util.BackoffIdleStrategy;
import io.camunda.operate.util.CollectionUtil;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.HttpAsyncResponseConsumerFactory;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.tasks.GetTaskRequest;
import org.elasticsearch.client.tasks.GetTaskResponse;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.ReindexRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.tasks.RawTaskStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public abstract class ElasticsearchUtil {
    public static final int SCROLL_KEEP_ALIVE_MS = 60000;
    public static final int TERMS_AGG_SIZE = 10000;
    public static final int QUERY_MAX_SIZE = 10000;
    public static final int TOPHITS_AGG_SIZE = 100;
    public static final int UPDATE_RETRY_COUNT = 3;
    public static final Function<SearchHit, Long> SEARCH_HIT_ID_TO_LONG = hit -> Long.valueOf(hit.getId());
    public static final Function<SearchHit, String> SEARCH_HIT_ID_TO_STRING = SearchHit::getId;
    public static RequestOptions requestOptions = RequestOptions.DEFAULT;
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticsearchUtil.class);

    public static void setRequestOptions(RequestOptions newRequestOptions) {
        requestOptions = newRequestOptions;
    }

    public static CompletableFuture<SearchResponse> searchAsync(SearchRequest searchRequest, Executor executor, RestHighLevelClient esClient) {
        CompletableFuture<SearchResponse> searchFuture = new CompletableFuture<SearchResponse>();
        esClient.searchAsync(searchRequest, RequestOptions.DEFAULT, new DelegatingActionListener(searchFuture, executor));
        return searchFuture;
    }

    public static CompletableFuture<Long> reindexAsyncWithConnectionRelease(ThreadPoolTaskScheduler executor, ReindexRequest reindexRequest, String sourceIndexName, RestHighLevelClient esClient) {
        CompletableFuture<String> reindexFuture = new CompletableFuture<String>();
        try {
            String taskId = esClient.submitReindexTask(reindexRequest, RequestOptions.DEFAULT).getTask();
            LOGGER.debug("Reindexing started for index {}. Task id: {}", (Object)sourceIndexName, (Object)taskId);
            reindexFuture.complete(taskId);
        }
        catch (IOException ex) {
            reindexFuture.completeExceptionally(ex);
        }
        return reindexFuture.thenCompose(tId -> ElasticsearchUtil.checkTaskResult(executor, tId, sourceIndexName, "reindex", esClient));
    }

    public static CompletableFuture<Long> deleteAsyncWithConnectionRelease(ThreadPoolTaskScheduler executor, String sourceIndexName, String idFieldName, List<Object> idValues, ObjectMapper objectMapper, RestHighLevelClient esClient) {
        CompletableFuture<String> deleteRequestFuture = new CompletableFuture<String>();
        try {
            String query = QueryBuilders.termsQuery((String)idFieldName, idValues).toString();
            Request deleteWithTaskRequest = new Request("POST", String.format("/%s/_delete_by_query", sourceIndexName));
            deleteWithTaskRequest.setJsonEntity(String.format("{\"query\": %s }", query));
            deleteWithTaskRequest.addParameter("wait_for_completion", "false");
            deleteWithTaskRequest.addParameter("slices", "auto");
            deleteWithTaskRequest.addParameter("conflicts", "proceed");
            Response response = esClient.getLowLevelClient().performRequest(deleteWithTaskRequest);
            if (response.getStatusLine().getStatusCode() != 200) {
                HttpEntity entity = response.getEntity();
                String errorMsg = String.format("Exception occurred when performing deletion. Status code: %s, error: %s", response.getStatusLine().getStatusCode(), entity == null ? "" : EntityUtils.toString((HttpEntity)entity));
                deleteRequestFuture.completeExceptionally((Throwable)new ArchiverException(errorMsg));
            }
            Map bodyMap = (Map)objectMapper.readValue(response.getEntity().getContent(), Map.class);
            String taskId = (String)bodyMap.get("task");
            LOGGER.debug("Deletion started for index {}. Task id {}", (Object)sourceIndexName, (Object)taskId);
            deleteRequestFuture.complete(taskId);
        }
        catch (IOException ex) {
            deleteRequestFuture.completeExceptionally(ex);
        }
        return deleteRequestFuture.thenCompose(tId -> ElasticsearchUtil.checkTaskResult(executor, tId, sourceIndexName, "delete", esClient));
    }

    private static CompletableFuture<Long> checkTaskResult(final ThreadPoolTaskScheduler executor, final String taskId, final String sourceIndexName, final String operation, final RestHighLevelClient esClient) {
        final CompletableFuture<Long> checkTaskResult = new CompletableFuture<Long>();
        final BackoffIdleStrategy idleStrategy = new BackoffIdleStrategy(1000L, 1.2f, 5000L);
        Runnable checkTaskResultRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    String[] taskIdParts = taskId.split(":");
                    GetTaskRequest getTaskRequest = new GetTaskRequest(taskIdParts[0], Long.parseLong(taskIdParts[1]));
                    Optional getTaskResponseOptional = esClient.tasks().get(getTaskRequest, RequestOptions.DEFAULT);
                    GetTaskResponse getTaskResponse = (GetTaskResponse)getTaskResponseOptional.orElseThrow(() -> new OperateRuntimeException("Task was not found: " + taskId));
                    if (getTaskResponse.isCompleted()) {
                        RawTaskStatus status = (RawTaskStatus)getTaskResponse.getTaskInfo().getStatus();
                        long total = ElasticsearchUtil.getTotalAffectedFromTask(sourceIndexName, operation, status);
                        checkTaskResult.complete(total);
                    } else {
                        idleStrategy.idle();
                        executor.schedule((Runnable)this, Date.from(Instant.now().plusMillis(idleStrategy.idleTime())));
                    }
                }
                catch (Exception e) {
                    checkTaskResult.completeExceptionally(e);
                }
            }
        };
        executor.submit(checkTaskResultRunnable);
        return checkTaskResult;
    }

    private static long getTotalAffectedFromTask(String sourceIndexName, String operation, RawTaskStatus status) {
        long deleted;
        long updated;
        Map statusMap = status.toMap();
        long total = ((Integer)statusMap.get("total")).intValue();
        long created = ((Integer)statusMap.get("created")).intValue();
        if (created + (updated = (long)((Integer)statusMap.get("updated")).intValue()) + (deleted = (long)((Integer)statusMap.get("deleted")).intValue()) < total) {
            String errorMsg = String.format("Failures occurred when performing operation %s on source index %s. Check Elasticsearch logs.", operation, sourceIndexName);
            throw new OperateRuntimeException(errorMsg);
        }
        LOGGER.debug("Operation {} succeeded on source index {}.", (Object)operation, (Object)sourceIndexName);
        return total;
    }

    public static SearchRequest createSearchRequest(TemplateDescriptor template) {
        return ElasticsearchUtil.createSearchRequest(template, QueryType.ALL);
    }

    public static SearchRequest createSearchRequest(TemplateDescriptor template, QueryType queryType) {
        SearchRequest searchRequest = new SearchRequest(new String[]{ElasticsearchUtil.whereToSearch(template, queryType)});
        return searchRequest;
    }

    private static String whereToSearch(TemplateDescriptor template, QueryType queryType) {
        switch (queryType.ordinal()) {
            case 0: {
                return template.getFullQualifiedName();
            }
        }
        return template.getAlias();
    }

    public static QueryBuilder joinWithOr(BoolQueryBuilder boolQueryBuilder, QueryBuilder ... queries) {
        List notNullQueries = CollectionUtil.throwAwayNullElements((Object[])queries);
        for (QueryBuilder query : notNullQueries) {
            boolQueryBuilder.should(query);
        }
        return boolQueryBuilder;
    }

    public static QueryBuilder joinWithOr(QueryBuilder ... queries) {
        List notNullQueries = CollectionUtil.throwAwayNullElements((Object[])queries);
        switch (notNullQueries.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (QueryBuilder)notNullQueries.get(0);
            }
        }
        BoolQueryBuilder boolQ = QueryBuilders.boolQuery();
        for (QueryBuilder query : notNullQueries) {
            boolQ.should(query);
        }
        return boolQ;
    }

    public static QueryBuilder joinWithOr(Collection<QueryBuilder> queries) {
        return ElasticsearchUtil.joinWithOr(queries.toArray(new QueryBuilder[queries.size()]));
    }

    public static QueryBuilder joinWithAnd(QueryBuilder ... queries) {
        List notNullQueries = CollectionUtil.throwAwayNullElements((Object[])queries);
        switch (notNullQueries.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (QueryBuilder)notNullQueries.get(0);
            }
        }
        BoolQueryBuilder boolQ = QueryBuilders.boolQuery();
        for (QueryBuilder query : notNullQueries) {
            boolQ.must(query);
        }
        return boolQ;
    }

    public static BoolQueryBuilder createMatchNoneQuery() {
        return QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.wrapperQuery((String)"{\"match_none\": {}}"));
    }

    public static void processBulkRequest(RestHighLevelClient esClient, BulkRequest bulkRequest, long maxBulkRequestSizeInBytes) throws PersistenceException {
        ElasticsearchUtil.processBulkRequest(esClient, bulkRequest, false, maxBulkRequestSizeInBytes);
    }

    public static void processBulkRequest(RestHighLevelClient esClient, BulkRequest bulkRequest, boolean refreshImmediately, long maxBulkRequestSizeInBytes) throws PersistenceException {
        if (bulkRequest.estimatedSizeInBytes() > maxBulkRequestSizeInBytes) {
            ElasticsearchUtil.divideLargeBulkRequestAndProcess(esClient, bulkRequest, refreshImmediately, maxBulkRequestSizeInBytes);
        } else {
            ElasticsearchUtil.processLimitedBulkRequest(esClient, bulkRequest, refreshImmediately);
        }
    }

    private static void divideLargeBulkRequestAndProcess(RestHighLevelClient esClient, BulkRequest bulkRequest, boolean refreshImmediately, long maxBulkRequestSizeInBytes) throws PersistenceException {
        LOGGER.debug("Bulk request has {} bytes > {} max bytes ({} requests). Will divide it into smaller bulk requests.", new Object[]{bulkRequest.estimatedSizeInBytes(), maxBulkRequestSizeInBytes, bulkRequest.requests().size()});
        List requests = bulkRequest.requests();
        BulkRequest limitedBulkRequest = new BulkRequest();
        for (int requestCount = 0; requestCount < requests.size(); ++requestCount) {
            DocWriteRequest nextRequest = (DocWriteRequest)requests.get(requestCount);
            if (nextRequest.ramBytesUsed() > maxBulkRequestSizeInBytes) {
                throw new PersistenceException(String.format("One of the request with size of %d bytes is greater than max allowed %d bytes", nextRequest.ramBytesUsed(), maxBulkRequestSizeInBytes));
            }
            long wholeSize = limitedBulkRequest.estimatedSizeInBytes() + nextRequest.ramBytesUsed();
            if (wholeSize < maxBulkRequestSizeInBytes) {
                limitedBulkRequest.add(nextRequest);
                continue;
            }
            LOGGER.debug("Submit bulk of {} requests, size {} bytes.", (Object)limitedBulkRequest.requests().size(), (Object)limitedBulkRequest.estimatedSizeInBytes());
            ElasticsearchUtil.processLimitedBulkRequest(esClient, limitedBulkRequest, refreshImmediately);
            limitedBulkRequest = new BulkRequest();
            limitedBulkRequest.add(nextRequest);
        }
        if (!limitedBulkRequest.requests().isEmpty()) {
            LOGGER.debug("Submit bulk of {} requests, size {} bytes.", (Object)limitedBulkRequest.requests().size(), (Object)limitedBulkRequest.estimatedSizeInBytes());
            ElasticsearchUtil.processLimitedBulkRequest(esClient, limitedBulkRequest, refreshImmediately);
        }
    }

    private static void processLimitedBulkRequest(RestHighLevelClient esClient, BulkRequest bulkRequest, boolean refreshImmediately) throws PersistenceException {
        if (bulkRequest.requests().size() > 0) {
            try {
                LOGGER.debug("************* FLUSH BULK START *************");
                if (refreshImmediately) {
                    bulkRequest = bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                }
                BulkResponse bulkItemResponses = esClient.bulk(bulkRequest, RequestOptions.DEFAULT);
                BulkItemResponse[] items = bulkItemResponses.getItems();
                for (int i = 0; i < items.length; ++i) {
                    BulkItemResponse responseItem = items[i];
                    if (!responseItem.isFailed() || ElasticsearchUtil.isEventConflictError(responseItem)) continue;
                    if (ElasticsearchUtil.isMissingIncident(responseItem)) {
                        DocWriteRequest request = (DocWriteRequest)bulkRequest.requests().get(i);
                        String incidentId = ElasticsearchUtil.extractIncidentId(responseItem.getFailure().getMessage());
                        String indexName = ElasticsearchUtil.getIndexNames(request.index() + "alias", Arrays.asList(incidentId), esClient).get(incidentId);
                        request.index(indexName);
                        if (indexName == null) {
                            LOGGER.warn("Index is not known for incident: " + incidentId);
                            continue;
                        }
                        esClient.update((UpdateRequest)request, RequestOptions.DEFAULT);
                        continue;
                    }
                    LOGGER.error(String.format("%s failed for type [%s] and id [%s]: %s", responseItem.getOpType(), responseItem.getIndex(), responseItem.getId(), responseItem.getFailureMessage()), (Throwable)responseItem.getFailure().getCause());
                    throw new PersistenceException("Operation failed: " + responseItem.getFailureMessage(), (Throwable)responseItem.getFailure().getCause(), Integer.valueOf(responseItem.getItemId()));
                }
                LOGGER.debug("************* FLUSH BULK FINISH *************");
            }
            catch (IOException ex) {
                throw new PersistenceException("Error when processing bulk request against Elasticsearch: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private static String extractIncidentId(String errorMessage) {
        Pattern fniPattern = Pattern.compile(".*\\[_doc\\]\\[(\\d*)\\].*");
        Matcher matcher = fniPattern.matcher(errorMessage);
        matcher.matches();
        return matcher.group(1);
    }

    private static boolean isMissingIncident(BulkItemResponse responseItem) {
        return responseItem.getIndex().contains("incident") && responseItem.getFailure().getStatus().equals((Object)RestStatus.NOT_FOUND);
    }

    private static boolean isEventConflictError(BulkItemResponse responseItem) {
        return responseItem.getIndex().contains("event") && responseItem.getFailure().getStatus().equals((Object)RestStatus.CONFLICT);
    }

    public static <T> List<T> mapSearchHits(List<HitEntity> hits, ObjectMapper objectMapper, JavaType valueType) {
        return CollectionUtil.map(hits, h -> ElasticsearchUtil.fromSearchHit(h.getSourceAsString(), objectMapper, valueType));
    }

    public static <T> List<T> mapSearchHits(HitEntity[] searchHits, ObjectMapper objectMapper, Class<T> clazz) {
        return CollectionUtil.map((Object[])searchHits, searchHit -> ElasticsearchUtil.fromSearchHit(searchHit.getSourceAsString(), objectMapper, clazz));
    }

    public static <T> List<T> mapSearchHits(SearchHit[] searchHits, Function<SearchHit, T> searchHitMapper) {
        return CollectionUtil.map((Object[])searchHits, searchHitMapper);
    }

    public static <T> List<T> mapSearchHits(SearchHit[] searchHits, ObjectMapper objectMapper, Class<T> clazz) {
        return CollectionUtil.map((Object[])searchHits, searchHit -> ElasticsearchUtil.fromSearchHit(searchHit.getSourceAsString(), objectMapper, clazz));
    }

    public static <T> T fromSearchHit(String searchHitString, ObjectMapper objectMapper, Class<T> clazz) {
        Object entity;
        try {
            entity = objectMapper.readValue(searchHitString, clazz);
        }
        catch (IOException e) {
            LOGGER.error(String.format("Error while reading entity of type %s from Elasticsearch!", clazz.getName()), (Throwable)e);
            throw new OperateRuntimeException(String.format("Error while reading entity of type %s from Elasticsearch!", clazz.getName()), (Throwable)e);
        }
        return (T)entity;
    }

    public static <T> List<T> mapSearchHits(SearchHit[] searchHits, ObjectMapper objectMapper, JavaType valueType) {
        return CollectionUtil.map((Object[])searchHits, searchHit -> ElasticsearchUtil.fromSearchHit(searchHit.getSourceAsString(), objectMapper, valueType));
    }

    public static <T> T fromSearchHit(String searchHitString, ObjectMapper objectMapper, JavaType valueType) {
        Object entity;
        try {
            entity = objectMapper.readValue(searchHitString, valueType);
        }
        catch (IOException e) {
            LOGGER.error(String.format("Error while reading entity of type %s from Elasticsearch!", valueType.toString()), (Throwable)e);
            throw new OperateRuntimeException(String.format("Error while reading entity of type %s from Elasticsearch!", valueType.toString()), (Throwable)e);
        }
        return (T)entity;
    }

    public static <T> List<T> scroll(SearchRequest searchRequest, Class<T> clazz, ObjectMapper objectMapper, RestHighLevelClient esClient) throws IOException {
        return ElasticsearchUtil.scroll(searchRequest, clazz, objectMapper, esClient, null, null);
    }

    public static <T> List<T> scroll(SearchRequest searchRequest, Class<T> clazz, ObjectMapper objectMapper, RestHighLevelClient esClient, Consumer<SearchHits> searchHitsProcessor, Consumer<Aggregations> aggsProcessor) throws IOException {
        return ElasticsearchUtil.scroll(searchRequest, clazz, objectMapper, esClient, null, searchHitsProcessor, aggsProcessor);
    }

    public static <T> List<T> scroll(SearchRequest searchRequest, Class<T> clazz, ObjectMapper objectMapper, RestHighLevelClient esClient, Function<SearchHit, T> searchHitMapper, Consumer<SearchHits> searchHitsProcessor, Consumer<Aggregations> aggsProcessor) throws IOException {
        searchRequest.scroll(TimeValue.timeValueMillis((long)60000L));
        SearchResponse response = esClient.search(searchRequest, RequestOptions.DEFAULT);
        if (aggsProcessor != null) {
            aggsProcessor.accept(response.getAggregations());
        }
        ArrayList<T> result = new ArrayList<T>();
        String scrollId = response.getScrollId();
        SearchHits hits = response.getHits();
        while (hits.getHits().length != 0) {
            if (searchHitMapper != null) {
                result.addAll(ElasticsearchUtil.mapSearchHits(hits.getHits(), searchHitMapper));
            } else {
                result.addAll(ElasticsearchUtil.mapSearchHits(hits.getHits(), objectMapper, clazz));
            }
            if (searchHitsProcessor != null) {
                searchHitsProcessor.accept(response.getHits());
            }
            SearchScrollRequest scrollRequest = new SearchScrollRequest(scrollId);
            scrollRequest.scroll(TimeValue.timeValueMillis((long)60000L));
            response = esClient.scroll(scrollRequest, RequestOptions.DEFAULT);
            scrollId = response.getScrollId();
            hits = response.getHits();
        }
        ElasticsearchUtil.clearScroll(scrollId, esClient);
        return result;
    }

    public static void scroll(SearchRequest searchRequest, Consumer<SearchHits> searchHitsProcessor, RestHighLevelClient esClient) throws IOException {
        ElasticsearchUtil.scroll(searchRequest, searchHitsProcessor, esClient, 60000L);
    }

    public static void scroll(SearchRequest searchRequest, Consumer<SearchHits> searchHitsProcessor, RestHighLevelClient esClient, long scrollKeepAlive) throws IOException {
        TimeValue scrollKeepAliveTimeValue = TimeValue.timeValueMillis((long)scrollKeepAlive);
        searchRequest.scroll(scrollKeepAliveTimeValue);
        SearchResponse response = esClient.search(searchRequest, RequestOptions.DEFAULT);
        String scrollId = response.getScrollId();
        SearchHits hits = response.getHits();
        while (hits.getHits().length != 0) {
            if (searchHitsProcessor != null) {
                searchHitsProcessor.accept(response.getHits());
            }
            SearchScrollRequest scrollRequest = new SearchScrollRequest(scrollId);
            scrollRequest.scroll(scrollKeepAliveTimeValue);
            response = esClient.scroll(scrollRequest, RequestOptions.DEFAULT);
            scrollId = response.getScrollId();
            hits = response.getHits();
        }
        ElasticsearchUtil.clearScroll(scrollId, esClient);
    }

    public static void scrollWith(SearchRequest searchRequest, RestHighLevelClient esClient, Consumer<SearchHits> searchHitsProcessor) throws IOException {
        ElasticsearchUtil.scrollWith(searchRequest, esClient, searchHitsProcessor, null, null);
    }

    public static void scrollWith(SearchRequest searchRequest, RestHighLevelClient esClient, Consumer<SearchHits> searchHitsProcessor, Consumer<Aggregations> aggsProcessor, Consumer<SearchHits> firstResponseConsumer) throws IOException {
        searchRequest.scroll(TimeValue.timeValueMillis((long)60000L));
        SearchResponse response = esClient.search(searchRequest, RequestOptions.DEFAULT);
        if (firstResponseConsumer != null) {
            firstResponseConsumer.accept(response.getHits());
        }
        if (aggsProcessor != null) {
            aggsProcessor.accept(response.getAggregations());
        }
        String scrollId = response.getScrollId();
        SearchHits hits = response.getHits();
        while (hits.getHits().length != 0) {
            if (searchHitsProcessor != null) {
                searchHitsProcessor.accept(response.getHits());
            }
            SearchScrollRequest scrollRequest = new SearchScrollRequest(scrollId);
            scrollRequest.scroll(TimeValue.timeValueMillis((long)60000L));
            response = esClient.scroll(scrollRequest, RequestOptions.DEFAULT);
            scrollId = response.getScrollId();
            hits = response.getHits();
        }
        ElasticsearchUtil.clearScroll(scrollId, esClient);
    }

    public static void clearScroll(String scrollId, RestHighLevelClient esClient) {
        if (scrollId != null) {
            ClearScrollRequest clearScrollRequest = new ClearScrollRequest();
            clearScrollRequest.addScrollId(scrollId);
            try {
                esClient.clearScroll(clearScrollRequest, RequestOptions.DEFAULT);
            }
            catch (Exception e) {
                LOGGER.warn("Error occurred when clearing the scroll with id [{}]", (Object)scrollId);
            }
        }
    }

    public static List<Long> scrollKeysToList(SearchRequest request, RestHighLevelClient esClient) throws IOException {
        ArrayList<Long> result = new ArrayList<Long>();
        Consumer<SearchHits> collectIds = hits -> result.addAll(CollectionUtil.map((Object[])hits.getHits(), SEARCH_HIT_ID_TO_LONG));
        ElasticsearchUtil.scrollWith(request, esClient, collectIds, null, collectIds);
        return result;
    }

    public static <T> List<T> scrollFieldToList(SearchRequest request, String fieldName, RestHighLevelClient esClient) throws IOException {
        ArrayList result = new ArrayList();
        Function<SearchHit, Object> searchHitFieldToString = searchHit -> searchHit.getSourceAsMap().get(fieldName);
        Consumer<SearchHits> collectFields = hits -> result.addAll(CollectionUtil.map((Object[])hits.getHits(), (Function)searchHitFieldToString));
        ElasticsearchUtil.scrollWith(request, esClient, collectFields, null, collectFields);
        return result;
    }

    public static Set<String> scrollIdsToSet(SearchRequest request, RestHighLevelClient esClient) throws IOException {
        HashSet<String> result = new HashSet<String>();
        Consumer<SearchHits> collectIds = hits -> result.addAll(CollectionUtil.map((Object[])hits.getHits(), SEARCH_HIT_ID_TO_STRING));
        ElasticsearchUtil.scrollWith(request, esClient, collectIds, null, collectIds);
        return result;
    }

    public static Map<String, String> getIndexNames(String aliasName, Collection<String> ids, RestHighLevelClient esClient) {
        HashMap<String, String> indexNames = new HashMap<String, String>();
        SearchRequest piRequest = new SearchRequest(new String[]{aliasName}).source(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.idsQuery().addIds((String[])ids.toArray(String[]::new))).fetchSource(false));
        try {
            ElasticsearchUtil.scrollWith(piRequest, esClient, sh -> indexNames.putAll(Arrays.stream(sh.getHits()).collect(Collectors.toMap(hit -> hit.getId(), hit -> hit.getIndex()))));
        }
        catch (IOException e) {
            throw new OperateRuntimeException(e.getMessage(), (Throwable)e);
        }
        return indexNames;
    }

    public static Map<String, String> getIndexNames(AbstractTemplateDescriptor template, Collection<String> ids, RestHighLevelClient esClient) {
        HashMap<String, String> indexNames = new HashMap<String, String>();
        SearchRequest piRequest = ElasticsearchUtil.createSearchRequest(template).source(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.idsQuery().addIds((String[])ids.toArray(String[]::new))).fetchSource(false));
        try {
            ElasticsearchUtil.scrollWith(piRequest, esClient, sh -> indexNames.putAll(Arrays.stream(sh.getHits()).collect(Collectors.toMap(hit -> hit.getId(), hit -> hit.getIndex()))));
        }
        catch (IOException e) {
            throw new OperateRuntimeException(e.getMessage(), (Throwable)e);
        }
        return indexNames;
    }

    public static Map<String, List<String>> getIndexNamesAsList(AbstractTemplateDescriptor template, Collection<String> ids, RestHighLevelClient esClient) {
        ConcurrentHashMap<String, List<String>> indexNames = new ConcurrentHashMap<String, List<String>>();
        SearchRequest piRequest = ElasticsearchUtil.createSearchRequest(template).source(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.idsQuery().addIds((String[])ids.toArray(String[]::new))).fetchSource(false));
        try {
            ElasticsearchUtil.scrollWith(piRequest, esClient, sh -> Arrays.stream(sh.getHits()).collect(Collectors.groupingBy(SearchHit::getId, Collectors.mapping(SearchHit::getIndex, Collectors.toList()))).forEach((key, value) -> indexNames.merge((String)key, (List<String>)value, (v1, v2) -> {
                v1.addAll(v2);
                return v1;
            })));
        }
        catch (IOException e) {
            throw new OperateRuntimeException(e.getMessage(), (Throwable)e);
        }
        return indexNames;
    }

    public static RequestOptions requestOptionsFor(int maxSizeInBytes) {
        RequestOptions.Builder options = RequestOptions.DEFAULT.toBuilder();
        options.setHttpAsyncResponseConsumerFactory((HttpAsyncResponseConsumerFactory)new HttpAsyncResponseConsumerFactory.HeapBufferedResponseConsumerFactory(maxSizeInBytes));
        return options.build();
    }

    public static SortOrder reverseOrder(SortOrder sortOrder) {
        if (sortOrder.equals((Object)SortOrder.ASC)) {
            return SortOrder.DESC;
        }
        return SortOrder.ASC;
    }

    private static final class DelegatingActionListener<Response>
    implements ActionListener<Response> {
        private final CompletableFuture<Response> future;
        private final Executor executorDelegate;

        private DelegatingActionListener(CompletableFuture<Response> future, Executor executor) {
            this.future = future;
            this.executorDelegate = executor;
        }

        public void onResponse(Response response) {
            this.executorDelegate.execute(() -> this.future.complete(response));
        }

        public void onFailure(Exception e) {
            this.executorDelegate.execute(() -> this.future.completeExceptionally(e));
        }
    }

    public static enum QueryType {
        ONLY_RUNTIME,
        ALL;

    }
}

