/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.store.opensearch.dsl;

import io.camunda.operate.schema.templates.TemplateDescriptor;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.cluster.PutComponentTemplateRequest;
import org.opensearch.client.opensearch.core.ClearScrollRequest;
import org.opensearch.client.opensearch.core.DeleteByQueryRequest;
import org.opensearch.client.opensearch.core.DeleteRequest;
import org.opensearch.client.opensearch.core.GetRequest;
import org.opensearch.client.opensearch.core.IndexRequest;
import org.opensearch.client.opensearch.core.ReindexRequest;
import org.opensearch.client.opensearch.core.ScrollRequest;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.UpdateRequest;
import org.opensearch.client.opensearch.core.reindex.Destination;
import org.opensearch.client.opensearch.core.reindex.Source;
import org.opensearch.client.opensearch.indices.CreateIndexRequest;
import org.opensearch.client.opensearch.indices.GetIndexRequest;
import org.opensearch.client.opensearch.indices.IndexState;
import org.opensearch.client.opensearch.snapshot.CreateSnapshotRequest;
import org.opensearch.client.opensearch.snapshot.DeleteSnapshotRequest;
import org.opensearch.client.opensearch.snapshot.GetRepositoryRequest;
import org.opensearch.client.opensearch.snapshot.GetSnapshotRequest;
import org.opensearch.client.util.ObjectBuilder;

public interface RequestDSL {
    private static String whereToSearch(TemplateDescriptor template, QueryType queryType) {
        return switch (queryType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> template.getFullQualifiedName();
            case 1 -> template.getAlias();
        };
    }

    public static CreateIndexRequest.Builder createIndexRequestBuilder(String index, IndexState patternIndex) {
        return new CreateIndexRequest.Builder().index(index).aliases(patternIndex.aliases()).mappings(patternIndex.mappings()).settings(s -> s.index(i -> i.numberOfReplicas(patternIndex.settings().index().numberOfReplicas()).numberOfShards(patternIndex.settings().index().numberOfShards()).analysis(patternIndex.settings().index().analysis())));
    }

    public static CreateSnapshotRequest.Builder createSnapshotRequestBuilder(String repository, String snapshot, List<String> indices) {
        return new CreateSnapshotRequest.Builder().repository(repository).snapshot(snapshot).indices(indices);
    }

    public static DeleteRequest.Builder deleteRequestBuilder(String index, String id) {
        return new DeleteRequest.Builder().index(index).id(id);
    }

    public static DeleteByQueryRequest.Builder deleteByQueryRequestBuilder(String index) {
        return new DeleteByQueryRequest.Builder().index(index, new String[0]);
    }

    public static DeleteSnapshotRequest.Builder deleteSnapshotRequestBuilder(String repositoryName, String snapshotName) {
        return new DeleteSnapshotRequest.Builder().repository(repositoryName).snapshot(snapshotName);
    }

    public static <R> IndexRequest.Builder<R> indexRequestBuilder(String index) {
        return new IndexRequest.Builder().index(index);
    }

    public static GetIndexRequest.Builder getIndexRequestBuilder(String index) {
        return new GetIndexRequest.Builder().index(index, new String[0]);
    }

    public static PutComponentTemplateRequest.Builder componentTemplateRequestBuilder(String name) {
        return new PutComponentTemplateRequest.Builder().name(name);
    }

    public static ReindexRequest.Builder reindexRequestBuilder(String srcIndex, Query srcQuery, String dstIndex) {
        return new ReindexRequest.Builder().source(Source.of(b -> b.index(srcIndex, new String[0]).query(srcQuery))).dest(Destination.of(b -> b.index(dstIndex)));
    }

    public static ReindexRequest.Builder reindexRequestBuilder(String srcIndex, String dstIndex, String script, Map<String, Object> scriptParams) {
        Map<String, JsonData> jsonParams = scriptParams.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> JsonData.of(e.getValue())));
        return new ReindexRequest.Builder().source(Source.of(b -> b.index(srcIndex, new String[0]))).dest(Destination.of(b -> b.index(dstIndex))).script(b -> b.inline(i -> (ObjectBuilder)i.source(script).params(jsonParams)));
    }

    public static GetRepositoryRequest.Builder repositoryRequestBuilder(String name) {
        return new GetRepositoryRequest.Builder().name(name, new String[0]);
    }

    public static SearchRequest.Builder searchRequestBuilder(String index) {
        return new SearchRequest.Builder().index(index, new String[0]);
    }

    public static SearchRequest.Builder searchRequestBuilder(TemplateDescriptor template, QueryType queryType) {
        SearchRequest.Builder builder = new SearchRequest.Builder();
        builder.index(RequestDSL.whereToSearch(template, queryType), new String[0]);
        return builder;
    }

    public static SearchRequest.Builder searchRequestBuilder(TemplateDescriptor template) {
        return RequestDSL.searchRequestBuilder(template, QueryType.ALL);
    }

    public static GetSnapshotRequest.Builder getSnapshotRequestBuilder(String repository, String snapshot) {
        return new GetSnapshotRequest.Builder().repository(repository).snapshot(snapshot, new String[0]);
    }

    public static <A, R> UpdateRequest.Builder<R, A> updateRequestBuilder(String index) {
        return new UpdateRequest.Builder().index(index);
    }

    public static GetRequest.Builder getRequestBuilder(String index) {
        return new GetRequest.Builder().index(index);
    }

    public static GetRequest getRequest(String index, String id) {
        return new GetRequest.Builder().index(index).id(id).build();
    }

    public static ScrollRequest scrollRequest(String scrollId, String time) {
        return new ScrollRequest.Builder().scrollId(scrollId).scroll(RequestDSL.time(time)).build();
    }

    public static ScrollRequest scrollRequest(String scrollId) {
        return RequestDSL.scrollRequest(scrollId, "60000ms");
    }

    public static ClearScrollRequest clearScrollRequest(String scrollId) {
        return new ClearScrollRequest.Builder().scrollId(scrollId, new String[0]).build();
    }

    public static Time time(String value) {
        return Time.of(b -> b.time(value));
    }

    public static enum QueryType {
        ONLY_RUNTIME,
        ALL;

    }
}

