/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.store.opensearch.client.sync;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.conditions.OpensearchCondition;
import io.camunda.operate.store.opensearch.client.sync.OpenSearchDocumentOperations;
import io.camunda.operate.store.opensearch.client.sync.OpenSearchIndexOperations;
import io.camunda.operate.store.opensearch.client.sync.OpenSearchTemplateOperations;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={OpensearchCondition.class})
@Component
public class ZeebeRichOpenSearchClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZeebeRichOpenSearchClient.class);
    BeanFactory beanFactory;
    OpenSearchClient openSearchClient;
    private final OpenSearchDocumentOperations openSearchDocumentOperations;
    private final OpenSearchIndexOperations openSearchIndexOperations;
    private final OpenSearchTemplateOperations openSearchTemplateOperations;

    public ZeebeRichOpenSearchClient(BeanFactory beanFactory, @Qualifier(value="zeebeOpensearchClient") OpenSearchClient openSearchClient, @Qualifier(value="operateObjectMapper") ObjectMapper objectMapper) {
        this.beanFactory = beanFactory;
        this.openSearchClient = openSearchClient;
        this.openSearchDocumentOperations = new OpenSearchDocumentOperations(LOGGER, openSearchClient);
        this.openSearchIndexOperations = new OpenSearchIndexOperations(LOGGER, openSearchClient, objectMapper);
        this.openSearchTemplateOperations = new OpenSearchTemplateOperations(LOGGER, openSearchClient);
    }

    public OpenSearchDocumentOperations doc() {
        return this.openSearchDocumentOperations;
    }

    public OpenSearchIndexOperations index() {
        return this.openSearchIndexOperations;
    }

    public OpenSearchTemplateOperations template() {
        return this.openSearchTemplateOperations;
    }
}

