/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.store.opensearch.client.sync;

import io.camunda.operate.exceptions.OperateRuntimeException;
import io.camunda.operate.exceptions.PersistenceException;
import io.camunda.operate.store.BatchRequest;
import io.camunda.operate.store.opensearch.client.sync.OpenSearchSyncOperation;
import io.camunda.operate.util.ExceptionHelper;
import java.io.IOException;
import java.util.List;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch.core.BulkRequest;
import org.opensearch.client.opensearch.core.BulkResponse;
import org.opensearch.client.opensearch.core.bulk.BulkResponseItem;
import org.slf4j.Logger;
import org.springframework.beans.factory.BeanFactory;

public class OpenSearchBatchOperations
extends OpenSearchSyncOperation {
    private final BeanFactory beanFactory;

    public OpenSearchBatchOperations(Logger logger, OpenSearchClient openSearchClient, BeanFactory beanFactory) {
        super(logger, openSearchClient);
        this.beanFactory = beanFactory;
    }

    private void processBulkRequest(OpenSearchClient osClient, BulkRequest bulkRequest) throws PersistenceException {
        if (bulkRequest.operations().size() > 0) {
            try {
                this.logger.debug("************* FLUSH BULK START *************");
                BulkResponse bulkItemResponses = osClient.bulk(bulkRequest);
                List items = bulkItemResponses.items();
                for (BulkResponseItem responseItem : items) {
                    if (responseItem.error() == null) continue;
                    this.logger.error(String.format("%s failed for type [%s] and id [%s]: %s", responseItem.operationType(), responseItem.index(), responseItem.id(), responseItem.error().reason()), (Object)"error on OpenSearch BulkRequest");
                    throw new PersistenceException("Operation failed: " + responseItem.error().reason(), (Throwable)new OperateRuntimeException(responseItem.error().reason()), Integer.valueOf(responseItem.id()));
                }
                this.logger.debug("************* FLUSH BULK FINISH *************");
            }
            catch (IOException ex) {
                throw new PersistenceException("Error when processing bulk request against OpenSearch: " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public void bulk(BulkRequest.Builder bulkRequestBuilder) {
        this.bulk(bulkRequestBuilder.build());
    }

    public void bulk(BulkRequest bulkRequest) {
        ExceptionHelper.withOperateRuntimeException(() -> {
            this.processBulkRequest(this.openSearchClient, bulkRequest);
            return null;
        });
    }

    public BatchRequest newBatchRequest() {
        return (BatchRequest)this.beanFactory.getBean(BatchRequest.class);
    }
}

