/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.store.opensearch;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.conditions.OpensearchCondition;
import io.camunda.operate.entities.UserEntity;
import io.camunda.operate.exceptions.OperateRuntimeException;
import io.camunda.operate.schema.indices.UserIndex;
import io.camunda.operate.store.NotFoundException;
import io.camunda.operate.store.UserStore;
import java.io.IOException;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch._types.FieldValue;
import org.opensearch.client.opensearch.core.IndexResponse;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.opensearch.client.opensearch.core.search.Hit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Conditional(value={OpensearchCondition.class})
@Component
@DependsOn(value={"schemaStartup"})
@Profile(value={"!ldap-auth & !sso-auth & !identity-auth"})
public class OpensearchUserStore
implements UserStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpensearchUserStore.class);
    @Autowired
    protected OpenSearchClient openSearchClient;
    @Autowired
    @Qualifier(value="operateObjectMapper")
    protected ObjectMapper objectMapper;
    @Autowired
    private UserIndex userIndex;

    protected String userEntityToJSONString(UserEntity aUser) throws JsonProcessingException {
        return this.objectMapper.writeValueAsString((Object)aUser);
    }

    @Override
    public UserEntity getById(String id) {
        try {
            SearchResponse response = this.openSearchClient.search(r -> r.index(this.userIndex.getAlias(), new String[0]).query(q -> q.term(t -> t.field("userId").value(FieldValue.of((String)id)))), UserEntity.class);
            long hits = response.hits().total().value();
            if (hits == 1L) {
                return (UserEntity)((Hit)response.hits().hits().get(0)).source();
            }
            if (hits > 1L) {
                throw new NotFoundException(String.format("Could not find unique user with userId '%s'.", id));
            }
            throw new NotFoundException(String.format("Could not find user with userId '%s'.", id));
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while obtaining the user: %s", e.getMessage());
            throw new OperateRuntimeException(message, (Throwable)e);
        }
    }

    @Override
    public void save(UserEntity user) {
        try {
            IndexResponse response = this.openSearchClient.index(r -> r.index(this.userIndex.getFullQualifiedName()).id(user.getId()).document((Object)user));
            LOGGER.info("User {} {}", (Object)user.getUserId(), (Object)response.result());
        }
        catch (Exception t) {
            LOGGER.error("Could not create user with userId {}", (Object)user.getUserId(), (Object)t);
        }
    }
}

