/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.store.opensearch;

import io.camunda.operate.conditions.OpensearchCondition;
import io.camunda.operate.entities.MetricEntity;
import io.camunda.operate.exceptions.OperateRuntimeException;
import io.camunda.operate.exceptions.PersistenceException;
import io.camunda.operate.schema.indices.MetricIndex;
import io.camunda.operate.store.BatchRequest;
import io.camunda.operate.store.MetricsStore;
import io.camunda.operate.store.opensearch.client.sync.RichOpenSearchClient;
import io.camunda.operate.store.opensearch.dsl.AggregationDSL;
import io.camunda.operate.store.opensearch.dsl.QueryDSL;
import io.camunda.operate.store.opensearch.dsl.RequestDSL;
import java.time.OffsetDateTime;
import java.util.List;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={OpensearchCondition.class})
@Component
public class OpensearchMetricsStore
implements MetricsStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpensearchMetricsStore.class);
    @Autowired
    private MetricIndex metricIndex;
    @Autowired
    private RichOpenSearchClient richOpenSearchClient;

    private AggregationResult searchWithAggregation(SearchRequest.Builder requestBuilder, String aggregationName) {
        Aggregate aggregate;
        try {
            aggregate = (Aggregate)this.richOpenSearchClient.doc().search(requestBuilder, Object.class).aggregations().get(aggregationName);
        }
        catch (OperateRuntimeException e) {
            return new AggregationResult(true, null, null);
        }
        if (aggregate == null) {
            throw new OperateRuntimeException("Search with aggregation returned no aggregation");
        }
        if (!aggregate.isSterms()) {
            throw new OperateRuntimeException("Unexpected response for aggregations");
        }
        List buckets = aggregate.sterms().buckets().array();
        List<RichOpenSearchClient.AggregationValue> values = buckets.stream().map(bucket -> new RichOpenSearchClient.AggregationValue(bucket.key(), bucket.docCount())).toList();
        long sumOfOtherDocCounts = aggregate.sterms().sumOtherDocCount();
        long total = sumOfOtherDocCounts + (long)values.size();
        return new AggregationResult(false, values, total);
    }

    @Override
    public Long retrieveProcessInstanceCount(OffsetDateTime startTime, OffsetDateTime endTime) {
        boolean limit = true;
        SearchRequest.Builder searchRequestBuilder = RequestDSL.searchRequestBuilder(this.metricIndex.getFullQualifiedName()).query(QueryDSL.and(QueryDSL.gteLte("eventTime", startTime, endTime), QueryDSL.or(QueryDSL.term("event", "EVENT_PROCESS_INSTANCE_FINISHED"), QueryDSL.term("event", "EVENT_PROCESS_INSTANCE_STARTED")))).aggregations("process_instances", AggregationDSL.termAggregation("value", 1)._toAggregation());
        return this.searchWithAggregation(searchRequestBuilder, "process_instances").totalDocs();
    }

    @Override
    public Long retrieveDecisionInstanceCount(OffsetDateTime startTime, OffsetDateTime endTime) {
        boolean limit = true;
        SearchRequest.Builder searchRequestBuilder = RequestDSL.searchRequestBuilder(this.metricIndex.getFullQualifiedName()).query(QueryDSL.and(QueryDSL.term("event", "EVENT_DECISION_INSTANCE_EVALUATED"), QueryDSL.gteLte("eventTime", startTime, endTime))).aggregations("decision_instances", AggregationDSL.termAggregation("value", 1)._toAggregation());
        return this.searchWithAggregation(searchRequestBuilder, "decision_instances").totalDocs();
    }

    @Override
    public void registerProcessInstanceStartEvent(String processInstanceKey, String tenantId, OffsetDateTime timestamp, BatchRequest batchRequest) throws PersistenceException {
        MetricEntity metric = this.createProcessInstanceStartedKey(processInstanceKey, tenantId, timestamp);
        batchRequest.add(this.metricIndex.getFullQualifiedName(), metric);
    }

    @Override
    public void registerDecisionInstanceCompleteEvent(String decisionInstanceKey, String tenantId, OffsetDateTime timestamp, BatchRequest batchRequest) throws PersistenceException {
        MetricEntity metric = this.createDecisionsInstanceEvaluatedKey(decisionInstanceKey, tenantId, timestamp);
        batchRequest.add(this.metricIndex.getFullQualifiedName(), metric);
    }

    private MetricEntity createProcessInstanceStartedKey(String processInstanceKey, String tenantId, OffsetDateTime timestamp) {
        return new MetricEntity().setEvent("EVENT_PROCESS_INSTANCE_STARTED").setValue(processInstanceKey).setTenantId(tenantId).setEventTime(timestamp);
    }

    private MetricEntity createDecisionsInstanceEvaluatedKey(String decisionInstanceKey, String tenantId, OffsetDateTime timestamp) {
        return new MetricEntity().setEvent("EVENT_DECISION_INSTANCE_EVALUATED").setValue(decisionInstanceKey).setTenantId(tenantId).setEventTime(timestamp);
    }

    private record AggregationResult(boolean error, List<RichOpenSearchClient.AggregationValue> values, Long totalDocs) {
    }
}

