/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.store.elasticsearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.conditions.ElasticsearchCondition;
import io.camunda.operate.entities.ProcessEntity;
import io.camunda.operate.entities.listview.ProcessInstanceForListViewEntity;
import io.camunda.operate.entities.listview.ProcessInstanceState;
import io.camunda.operate.exceptions.OperateRuntimeException;
import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.schema.indices.ProcessIndex;
import io.camunda.operate.schema.templates.ListViewTemplate;
import io.camunda.operate.schema.templates.OperationTemplate;
import io.camunda.operate.schema.templates.ProcessInstanceDependant;
import io.camunda.operate.schema.templates.TemplateDescriptor;
import io.camunda.operate.store.NotFoundException;
import io.camunda.operate.store.ProcessStore;
import io.camunda.operate.tenant.TenantAwareElasticsearchClient;
import io.camunda.operate.util.ElasticsearchUtil;
import io.camunda.operate.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.IdsQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.SingleBucketAggregation;
import org.elasticsearch.search.aggregations.bucket.filter.FilterAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.Cardinality;
import org.elasticsearch.search.aggregations.metrics.TopHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;

@Conditional(value={ElasticsearchCondition.class})
@Component
public class ElasticsearchProcessStore
implements ProcessStore {
    public static final FilterAggregationBuilder INCIDENTS_AGGREGATION = AggregationBuilders.filter((String)"incidents", (QueryBuilder)ElasticsearchUtil.joinWithAnd(new QueryBuilder[]{QueryBuilders.termQuery((String)"incident", (boolean)true), QueryBuilders.termQuery((String)"joinRelation", (String)"processInstance")}));
    public static final FilterAggregationBuilder RUNNING_AGGREGATION = AggregationBuilders.filter((String)"running", (QueryBuilder)QueryBuilders.termQuery((String)"state", (Object)((Object)ProcessInstanceState.ACTIVE)));
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticsearchProcessStore.class);
    private static final String DISTINCT_FIELD_COUNTS = "distinctFieldCounts";
    private final ProcessIndex processIndex;
    private final ListViewTemplate listViewTemplate;
    private final List<ProcessInstanceDependant> processInstanceDependantTemplates;
    private final ObjectMapper objectMapper;
    private final RestHighLevelClient esClient;
    private final TenantAwareElasticsearchClient tenantAwareClient;
    private final OperateProperties operateProperties;

    public ElasticsearchProcessStore(ProcessIndex processIndex, ListViewTemplate listViewTemplate, List<ProcessInstanceDependant> processInstanceDependantTemplates, @Qualifier(value="operateObjectMapper") ObjectMapper objectMapper, OperateProperties operateProperties, RestHighLevelClient esClient, TenantAwareElasticsearchClient tenantAwareClient) {
        this.processIndex = processIndex;
        this.listViewTemplate = listViewTemplate;
        this.processInstanceDependantTemplates = processInstanceDependantTemplates;
        this.objectMapper = objectMapper;
        this.operateProperties = operateProperties;
        this.esClient = esClient;
        this.tenantAwareClient = tenantAwareClient;
    }

    @Override
    public Optional<Long> getDistinctCountFor(String fieldName) {
        String indexAlias = this.processIndex.getAlias();
        LOGGER.debug("Called distinct count for field {} in index alias {}.", (Object)fieldName, (Object)indexAlias);
        SearchRequest searchRequest = new SearchRequest(new String[]{indexAlias}).source(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.matchAllQuery()).size(0).aggregation((AggregationBuilder)AggregationBuilders.cardinality((String)DISTINCT_FIELD_COUNTS).precisionThreshold(1000L).field(fieldName)));
        try {
            SearchResponse searchResponse = this.esClient.search(searchRequest, RequestOptions.DEFAULT);
            Cardinality distinctFieldCounts = (Cardinality)searchResponse.getAggregations().get(DISTINCT_FIELD_COUNTS);
            return Optional.of(distinctFieldCounts.getValue());
        }
        catch (Exception e) {
            LOGGER.error(String.format("Error in distinct count for field %s in index alias %s.", fieldName, indexAlias), (Throwable)e);
            return Optional.empty();
        }
    }

    @Override
    public void refreshIndices(String ... indices) {
        if (indices == null || indices.length == 0) {
            throw new OperateRuntimeException("Refresh indices needs at least one index to refresh.");
        }
        try {
            this.esClient.indices().refresh(new RefreshRequest(indices), RequestOptions.DEFAULT);
        }
        catch (IOException ex) {
            throw new OperateRuntimeException("Failed to refresh indices " + String.valueOf(Arrays.asList(indices)), (Throwable)ex);
        }
    }

    @Override
    public ProcessEntity getProcessByKey(Long processDefinitionKey) {
        SearchRequest searchRequest = new SearchRequest(new String[]{this.processIndex.getAlias()}).source(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.termQuery((String)"key", (Object)processDefinitionKey)));
        try {
            SearchResponse response = this.tenantAwareClient.search(searchRequest);
            if (response.getHits().getTotalHits().value == 1L) {
                return this.fromSearchHit(response.getHits().getHits()[0].getSourceAsString());
            }
            if (response.getHits().getTotalHits().value > 1L) {
                throw new NotFoundException(String.format("Could not find unique process with key '%s'.", processDefinitionKey));
            }
            throw new NotFoundException(String.format("Could not find process with key '%s'.", processDefinitionKey));
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while obtaining the process: %s", e.getMessage());
            LOGGER.error(message, (Throwable)e);
            throw new OperateRuntimeException(message, (Throwable)e);
        }
    }

    @Override
    public String getDiagramByKey(Long processDefinitionKey) {
        IdsQueryBuilder q = QueryBuilders.idsQuery().addIds(new String[]{processDefinitionKey.toString()});
        SearchRequest searchRequest = new SearchRequest(new String[]{this.processIndex.getAlias()}).source(new SearchSourceBuilder().query((QueryBuilder)q).fetchSource("bpmnXml", null));
        try {
            SearchResponse response = this.tenantAwareClient.search(searchRequest);
            if (response.getHits().getTotalHits().value == 1L) {
                Map result = response.getHits().getHits()[0].getSourceAsMap();
                return (String)result.get("bpmnXml");
            }
            if (response.getHits().getTotalHits().value > 1L) {
                throw new NotFoundException(String.format("Could not find unique process with id '%s'.", processDefinitionKey));
            }
            throw new NotFoundException(String.format("Could not find process with id '%s'.", processDefinitionKey));
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while obtaining the process diagram: %s", e.getMessage());
            LOGGER.error(message, (Throwable)e);
            throw new OperateRuntimeException(message, (Throwable)e);
        }
    }

    @Override
    public Map<ProcessStore.ProcessKey, List<ProcessEntity>> getProcessesGrouped(String tenantId, @Nullable Set<String> allowedBPMNProcessIds) {
        String tenantsGroupsAggName = "group_by_tenantId";
        String groupsAggName = "group_by_bpmnProcessId";
        String processesAggName = "processes";
        AbstractAggregationBuilder agg = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"group_by_tenantId").field("tenantId")).size(10000).subAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"group_by_bpmnProcessId").field("bpmnProcessId")).size(10000).subAggregation((AggregationBuilder)AggregationBuilders.topHits((String)"processes").fetchSource(new String[]{"id", "name", "version", "versionTag", "bpmnProcessId", "tenantId"}, null).size(100).sort("version", SortOrder.DESC)));
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().aggregation((AggregationBuilder)agg).size(0);
        sourceBuilder.query(this.buildQuery(tenantId, allowedBPMNProcessIds));
        SearchRequest searchRequest = new SearchRequest(new String[]{this.processIndex.getAlias()}).source(sourceBuilder);
        try {
            SearchResponse searchResponse = this.tenantAwareClient.search(searchRequest);
            Terms groups = (Terms)searchResponse.getAggregations().get("group_by_tenantId");
            HashMap<ProcessStore.ProcessKey, List<ProcessEntity>> result = new HashMap<ProcessStore.ProcessKey, List<ProcessEntity>>();
            groups.getBuckets().stream().forEach(b -> {
                String groupTenantId = b.getKeyAsString();
                Terms processGroups = (Terms)b.getAggregations().get("group_by_bpmnProcessId");
                processGroups.getBuckets().stream().forEach(tenantB -> {
                    SearchHit[] hits;
                    String bpmnProcessId = tenantB.getKeyAsString();
                    ProcessStore.ProcessKey groupKey = new ProcessStore.ProcessKey(bpmnProcessId, groupTenantId);
                    result.put(groupKey, new ArrayList());
                    TopHits processes = (TopHits)tenantB.getAggregations().get("processes");
                    for (SearchHit searchHit : hits = processes.getHits().getHits()) {
                        ProcessEntity processEntity = this.fromSearchHit(searchHit.getSourceAsString());
                        ((List)result.get(groupKey)).add(processEntity);
                    }
                });
            });
            return result;
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while obtaining grouped processes: %s", e.getMessage());
            LOGGER.error(message, (Throwable)e);
            throw new OperateRuntimeException(message, (Throwable)e);
        }
    }

    @Override
    public Map<Long, ProcessEntity> getProcessesIdsToProcessesWithFields(@Nullable Set<String> allowedBPMNIds, int maxSize, String ... fields) {
        HashMap<Long, ProcessEntity> map = new HashMap<Long, ProcessEntity>();
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().size(maxSize).fetchSource(fields, null);
        if (allowedBPMNIds == null) {
            sourceBuilder.query((QueryBuilder)QueryBuilders.matchAllQuery());
        } else {
            sourceBuilder.query((QueryBuilder)QueryBuilders.termsQuery((String)"bpmnProcessId", allowedBPMNIds));
        }
        SearchRequest searchRequest = new SearchRequest(new String[]{this.processIndex.getAlias()}).source(sourceBuilder);
        try {
            SearchResponse response = this.tenantAwareClient.search(searchRequest);
            response.getHits().forEach(hit -> {
                ProcessEntity entity = this.fromSearchHit(hit.getSourceAsString());
                map.put(entity.getKey(), entity);
            });
            return map;
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while obtaining processes: %s", e.getMessage());
            LOGGER.error(message, (Throwable)e);
            throw new OperateRuntimeException(message, (Throwable)e);
        }
    }

    @Override
    public long deleteProcessDefinitionsByKeys(Long ... processDefinitionKeys) {
        if (processDefinitionKeys == null || processDefinitionKeys.length == 0) {
            return 0L;
        }
        DeleteByQueryRequest query = new DeleteByQueryRequest(new String[]{this.processIndex.getAlias()}).setQuery((QueryBuilder)QueryBuilders.termsQuery((String)"key", (Object[])processDefinitionKeys));
        try {
            BulkByScrollResponse response = this.esClient.deleteByQuery(query, RequestOptions.DEFAULT);
            return response.getDeleted();
        }
        catch (IOException ex) {
            throw new OperateRuntimeException("Failed to delete process definitions by keys", (Throwable)ex);
        }
    }

    @Override
    public ProcessInstanceForListViewEntity getProcessInstanceListViewByKey(Long processInstanceKey) {
        try {
            QueryBuilder query = ElasticsearchUtil.joinWithAnd(new QueryBuilder[]{QueryBuilders.idsQuery().addIds(new String[]{String.valueOf(processInstanceKey)}), QueryBuilders.termQuery((String)"processInstanceKey", (Object)processInstanceKey)});
            SearchRequest request = ElasticsearchUtil.createSearchRequest(this.listViewTemplate, ElasticsearchUtil.QueryType.ALL).source(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)query)));
            SearchResponse response = this.tenantAwareClient.search(request);
            SearchHits searchHits = response.getHits();
            if (searchHits.getTotalHits().value == 1L && searchHits.getHits().length == 1) {
                return ElasticsearchUtil.fromSearchHit(searchHits.getAt(0).getSourceAsString(), this.objectMapper, ProcessInstanceForListViewEntity.class);
            }
            if (response.getHits().getTotalHits().value > 1L) {
                throw new NotFoundException(String.format("Could not find unique process instance with id '%s'.", processInstanceKey));
            }
            throw new NotFoundException(String.format("Could not find process instance with id '%s'.", processInstanceKey));
        }
        catch (IOException e) {
            throw new OperateRuntimeException((Throwable)e);
        }
    }

    @Override
    public Map<String, Long> getCoreStatistics(@Nullable Set<String> allowedBPMNIds) {
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().size(0).aggregation((AggregationBuilder)INCIDENTS_AGGREGATION).aggregation((AggregationBuilder)RUNNING_AGGREGATION);
        if (allowedBPMNIds == null) {
            sourceBuilder.query((QueryBuilder)QueryBuilders.matchAllQuery());
        } else {
            sourceBuilder.query((QueryBuilder)QueryBuilders.termsQuery((String)"bpmnProcessId", allowedBPMNIds));
        }
        SearchRequest searchRequest = ElasticsearchUtil.createSearchRequest(this.listViewTemplate, ElasticsearchUtil.QueryType.ONLY_RUNTIME).source(sourceBuilder);
        try {
            SearchResponse response = this.tenantAwareClient.search(searchRequest);
            Aggregations aggregations = response.getAggregations();
            long runningCount = ((SingleBucketAggregation)aggregations.get("running")).getDocCount();
            long incidentCount = ((SingleBucketAggregation)aggregations.get("incidents")).getDocCount();
            return Map.of("running", runningCount, "incidents", incidentCount);
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while obtaining process instance core statistics: %s", e.getMessage());
            LOGGER.error(message, (Throwable)e);
            throw new OperateRuntimeException(message, (Throwable)e);
        }
    }

    @Override
    public String getProcessInstanceTreePathById(String processInstanceId) {
        QueryBuilder query = ElasticsearchUtil.joinWithAnd(new QueryBuilder[]{QueryBuilders.termQuery((String)"joinRelation", (String)"processInstance"), QueryBuilders.termQuery((String)"key", (String)processInstanceId)});
        SearchRequest request = ElasticsearchUtil.createSearchRequest(this.listViewTemplate).source(new SearchSourceBuilder().query(query).fetchSource("treePath", null));
        try {
            SearchResponse response = this.tenantAwareClient.search(request);
            if (response.getHits().getTotalHits().value > 0L) {
                return (String)response.getHits().getAt(0).getSourceAsMap().get("treePath");
            }
            throw new NotFoundException(String.format("Process instance not found: %s", processInstanceId));
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while obtaining tree path for process instance: %s", e.getMessage());
            throw new OperateRuntimeException(message, (Throwable)e);
        }
    }

    @Override
    public List<Map<String, String>> createCallHierarchyFor(List<String> processInstanceIds, String currentProcessInstanceId) {
        ArrayList<Map<String, String>> callHierarchy = new ArrayList<Map<String, String>>();
        ArrayList<String> processInstanceIdsWithoutCurrentProcess = new ArrayList<String>(processInstanceIds);
        processInstanceIdsWithoutCurrentProcess.remove(currentProcessInstanceId);
        QueryBuilder query = ElasticsearchUtil.joinWithAnd(new QueryBuilder[]{QueryBuilders.termQuery((String)"joinRelation", (String)"processInstance"), QueryBuilders.termsQuery((String)"id", processInstanceIdsWithoutCurrentProcess)});
        SearchRequest request = ElasticsearchUtil.createSearchRequest(this.listViewTemplate).source(new SearchSourceBuilder().query(query).fetchSource(new String[]{"id", "processDefinitionKey", "processName", "bpmnProcessId"}, null));
        try {
            this.tenantAwareClient.search(request, () -> {
                ElasticsearchUtil.scrollWith(request, this.esClient, searchHits -> Arrays.stream(searchHits.getHits()).forEach(sh -> {
                    Map source = sh.getSourceAsMap();
                    callHierarchy.add(Map.of("instanceId", String.valueOf(source.get("id")), "processDefinitionId", String.valueOf(source.get("processDefinitionKey")), "processDefinitionName", String.valueOf(source.getOrDefault("processName", source.get("bpmnProcessId")))));
                }));
                return null;
            });
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while obtaining process instance call hierarchy: %s", e.getMessage());
            throw new OperateRuntimeException(message, (Throwable)e);
        }
        return callHierarchy;
    }

    @Override
    public long deleteDocument(String indexName, String idField, String id) throws IOException {
        DeleteByQueryRequest query = new DeleteByQueryRequest(new String[]{indexName}).setQuery((QueryBuilder)QueryBuilders.termsQuery((String)idField, (String[])new String[]{id}));
        BulkByScrollResponse response = this.esClient.deleteByQuery(query, RequestOptions.DEFAULT);
        LOGGER.debug("Delete document {} in {} response: {}", new Object[]{id, indexName, response.getStatus()});
        return response.getDeleted();
    }

    @Override
    public void deleteProcessInstanceFromTreePath(String processInstanceKey) {
        BulkRequest bulkRequest = new BulkRequest();
        String treePath = this.getProcessInstanceTreePathById(processInstanceKey);
        BoolQueryBuilder query = ((BoolQueryBuilder)ElasticsearchUtil.joinWithAnd(new QueryBuilder[]{QueryBuilders.termQuery((String)"joinRelation", (String)"processInstance"), QueryBuilders.termQuery((String)"treePath", (String)treePath)})).mustNot((QueryBuilder)QueryBuilders.termQuery((String)"key", (String)processInstanceKey));
        SearchRequest request = ElasticsearchUtil.createSearchRequest(this.listViewTemplate).source(new SearchSourceBuilder().query((QueryBuilder)query).fetchSource("treePath", null));
        try {
            this.tenantAwareClient.search(request, () -> {
                ElasticsearchUtil.scroll(request, hits -> Arrays.stream(hits.getHits()).forEach(sh -> {
                    UpdateRequest updateRequest = new UpdateRequest();
                    HashMap<String, String> updateFields = new HashMap<String, String>();
                    String newTreePath = new TreePath((String)sh.getSourceAsMap().get("treePath")).removeProcessInstance(processInstanceKey).toString();
                    updateFields.put("treePath", newTreePath);
                    ((UpdateRequest)updateRequest.index(sh.getIndex())).id(sh.getId()).doc(updateFields).retryOnConflict(3);
                    bulkRequest.add(updateRequest);
                }), this.esClient);
                return null;
            });
            ElasticsearchUtil.processBulkRequest(this.esClient, bulkRequest, this.operateProperties.getElasticsearch().getBulkRequestMaxSizeInBytes());
        }
        catch (Exception e) {
            throw new OperateRuntimeException(String.format("Exception occurred when deleting process instance %s from tree path: %s", processInstanceKey, e.getMessage()));
        }
    }

    @Override
    public List<ProcessInstanceForListViewEntity> getProcessInstancesByProcessAndStates(long processDefinitionKey, Set<ProcessInstanceState> states, int size, String[] includeFields) {
        if (states == null || states.isEmpty()) {
            throw new OperateRuntimeException("Parameter 'states' is needed to search by states.");
        }
        QueryBuilder query = ElasticsearchUtil.joinWithAnd(new QueryBuilder[]{QueryBuilders.termQuery((String)"joinRelation", (String)"processInstance"), QueryBuilders.termQuery((String)"processDefinitionKey", (long)processDefinitionKey), QueryBuilders.termsQuery((String)"state", (Collection)states.stream().map(Enum::name).collect(Collectors.toList()))});
        SearchSourceBuilder source = new SearchSourceBuilder().size(size).query(query).fetchSource(includeFields, null);
        SearchRequest searchRequest = ElasticsearchUtil.createSearchRequest(this.listViewTemplate, ElasticsearchUtil.QueryType.ALL).source(source);
        try {
            SearchResponse response = this.tenantAwareClient.search(searchRequest);
            return ElasticsearchUtil.mapSearchHits(response.getHits().getHits(), this.objectMapper, ProcessInstanceForListViewEntity.class);
        }
        catch (IOException ex) {
            throw new OperateRuntimeException(String.format("Failed to search process instances by processDefinitionKey [%s] and states [%s]", processDefinitionKey, states), (Throwable)ex);
        }
    }

    @Override
    public List<ProcessInstanceForListViewEntity> getProcessInstancesByParentKeys(Set<Long> parentProcessInstanceKeys, int size, String[] includeFields) {
        if (parentProcessInstanceKeys == null || parentProcessInstanceKeys.isEmpty()) {
            throw new OperateRuntimeException("Parameter 'parentProcessInstanceKeys' is needed to search by parents.");
        }
        QueryBuilder query = ElasticsearchUtil.joinWithAnd(new QueryBuilder[]{QueryBuilders.termQuery((String)"joinRelation", (String)"processInstance"), QueryBuilders.termsQuery((String)"parentProcessInstanceKey", parentProcessInstanceKeys)});
        SearchSourceBuilder source = new SearchSourceBuilder().size(size).query(query).fetchSource(includeFields, null);
        SearchRequest searchRequest = ElasticsearchUtil.createSearchRequest(this.listViewTemplate, ElasticsearchUtil.QueryType.ALL).source(source);
        try {
            return (List)this.tenantAwareClient.search(searchRequest, () -> ElasticsearchUtil.scroll(searchRequest, ProcessInstanceForListViewEntity.class, this.objectMapper, this.esClient));
        }
        catch (IOException ex) {
            throw new OperateRuntimeException("Failed to search process instances by parentProcessInstanceKeys", (Throwable)ex);
        }
    }

    @Override
    public long deleteProcessInstancesAndDependants(Set<Long> processInstanceKeys) {
        BulkByScrollResponse response;
        if (processInstanceKeys == null || processInstanceKeys.isEmpty()) {
            return 0L;
        }
        long count = 0L;
        List<ProcessInstanceDependant> processInstanceDependantsWithoutOperation = this.processInstanceDependantTemplates.stream().filter(template -> !(template instanceof OperationTemplate)).toList();
        try {
            for (ProcessInstanceDependant template2 : processInstanceDependantsWithoutOperation) {
                String indexName = ((TemplateDescriptor)((Object)template2)).getAlias();
                DeleteByQueryRequest query = new DeleteByQueryRequest(new String[]{indexName}).setQuery((QueryBuilder)QueryBuilders.termsQuery((String)"processInstanceKey", processInstanceKeys));
                BulkByScrollResponse response2 = this.esClient.deleteByQuery(query, RequestOptions.DEFAULT);
                count += response2.getDeleted();
            }
            DeleteByQueryRequest query = new DeleteByQueryRequest(new String[]{this.listViewTemplate.getAlias()}).setQuery((QueryBuilder)QueryBuilders.termsQuery((String)"processInstanceKey", processInstanceKeys));
            response = this.esClient.deleteByQuery(query, RequestOptions.DEFAULT);
        }
        catch (IOException ex) {
            throw new OperateRuntimeException("Failed to delete process instances and dependants by keys", (Throwable)ex);
        }
        return count += response.getDeleted();
    }

    private QueryBuilder buildQuery(String tenantId, Set<String> allowedBPMNProcessIds) {
        TermQueryBuilder tenantIdQ;
        TermsQueryBuilder bpmnProcessIdQ = allowedBPMNProcessIds != null ? QueryBuilders.termsQuery((String)"bpmnProcessId", allowedBPMNProcessIds) : null;
        QueryBuilder q = ElasticsearchUtil.joinWithAnd(new QueryBuilder[]{bpmnProcessIdQ, tenantIdQ = tenantId != null ? QueryBuilders.termQuery((String)"tenantId", (String)tenantId) : null});
        if (q == null) {
            q = QueryBuilders.matchAllQuery();
        }
        return q;
    }

    private ProcessEntity fromSearchHit(String processString) {
        return ElasticsearchUtil.fromSearchHit(processString, this.objectMapper, ProcessEntity.class);
    }
}

