/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.store.elasticsearch;

import io.camunda.operate.conditions.ElasticsearchCondition;
import io.camunda.operate.schema.indices.DecisionIndex;
import io.camunda.operate.store.BatchRequest;
import io.camunda.operate.store.DecisionStore;
import io.camunda.operate.tenant.TenantAwareElasticsearchClient;
import java.io.IOException;
import java.util.Optional;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.metrics.Cardinality;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={ElasticsearchCondition.class})
@Component
public class ElasticsearchDecisionStore
implements DecisionStore {
    private static final String DISTINCT_FIELD_COUNTS = "distinctFieldCounts";
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticsearchDecisionStore.class);
    @Autowired
    private DecisionIndex decisionIndex;
    @Autowired
    private BeanFactory beanFactory;
    @Autowired
    private RestHighLevelClient esClient;
    @Autowired
    private TenantAwareElasticsearchClient tenantAwareClient;

    @Override
    public Optional<Long> getDistinctCountFor(String fieldName) {
        String indexAlias = this.decisionIndex.getAlias();
        LOGGER.debug("Called distinct count for field {} in index alias {}.", (Object)fieldName, (Object)indexAlias);
        SearchRequest searchRequest = new SearchRequest(new String[]{indexAlias}).source(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.matchAllQuery()).size(0).aggregation((AggregationBuilder)AggregationBuilders.cardinality((String)DISTINCT_FIELD_COUNTS).precisionThreshold(1000L).field(fieldName)));
        try {
            SearchResponse searchResponse = this.esClient.search(searchRequest, RequestOptions.DEFAULT);
            Cardinality distinctFieldCounts = (Cardinality)searchResponse.getAggregations().get(DISTINCT_FIELD_COUNTS);
            return Optional.of(distinctFieldCounts.getValue());
        }
        catch (Exception e) {
            LOGGER.error(String.format("Error in distinct count for field %s in index alias %s.", fieldName, indexAlias), (Throwable)e);
            return Optional.empty();
        }
    }

    @Override
    public BatchRequest newBatchRequest() {
        return (BatchRequest)this.beanFactory.getBean(BatchRequest.class);
    }

    @Override
    public long deleteDocuments(String indexName, String idField, String id) throws IOException {
        DeleteByQueryRequest query = new DeleteByQueryRequest(new String[]{indexName}).setQuery((QueryBuilder)QueryBuilders.termsQuery((String)idField, (String[])new String[]{id}));
        BulkByScrollResponse response = this.esClient.deleteByQuery(query, RequestOptions.DEFAULT);
        LOGGER.debug("Delete document {} in {} response: {}", new Object[]{id, indexName, response.getStatus()});
        return response.getDeleted();
    }
}

