/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.schema.migration;

import io.camunda.operate.exceptions.MigrationException;
import io.camunda.operate.schema.SchemaManager;
import io.camunda.operate.schema.migration.ReindexPlan;
import io.camunda.operate.schema.migration.Step;
import java.util.List;
import java.util.Optional;

public abstract class PipelineReindexPlan
implements ReindexPlan {
    protected List<Step> steps = List.of();
    protected String srcIndex;
    protected String dstIndex;

    @Override
    public ReindexPlan setSrcIndex(String srcIndex) {
        this.srcIndex = srcIndex;
        return this;
    }

    @Override
    public ReindexPlan setDstIndex(String dstIndex) {
        this.dstIndex = dstIndex;
        return this;
    }

    @Override
    public ReindexPlan setSteps(List<Step> steps) {
        this.steps = steps;
        return this;
    }

    @Override
    public List<Step> getSteps() {
        return this.steps;
    }

    protected Optional<String> createPipelineFromSteps(SchemaManager schemaManager) throws MigrationException {
        if (this.steps.isEmpty()) {
            return Optional.empty();
        }
        String name = this.srcIndex + "-to-" + this.dstIndex + "-pipeline";
        boolean added = schemaManager.addPipeline(name, this.getPipelineDefinition());
        if (added) {
            return Optional.of(name);
        }
        throw new MigrationException(String.format("Couldn't create '%s' pipeline.", name));
    }

    protected abstract String getPipelineDefinition();
}

