/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.schema.migration;

import io.camunda.operate.conditions.DatabaseInfo;
import io.camunda.operate.exceptions.MigrationException;
import io.camunda.operate.property.MigrationProperties;
import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.schema.IndexSchemaValidator;
import io.camunda.operate.schema.SchemaManager;
import io.camunda.operate.schema.indices.IndexDescriptor;
import io.camunda.operate.schema.migration.DataInitializerStep;
import io.camunda.operate.schema.migration.FillPostImporterQueuePlan;
import io.camunda.operate.schema.migration.FillPostImporterQueueStep;
import io.camunda.operate.schema.migration.MigrationPlanFactory;
import io.camunda.operate.schema.migration.Plan;
import io.camunda.operate.schema.migration.ProcessorStep;
import io.camunda.operate.schema.migration.ReindexPlan;
import io.camunda.operate.schema.migration.ReindexWithQueryAndScriptPlan;
import io.camunda.operate.schema.migration.SemanticVersion;
import io.camunda.operate.schema.migration.SetBpmnProcessIdStep;
import io.camunda.operate.schema.migration.Step;
import io.camunda.operate.schema.migration.StepsRepository;
import io.camunda.operate.schema.templates.IncidentTemplate;
import io.camunda.operate.schema.templates.ListViewTemplate;
import io.camunda.operate.schema.templates.PostImporterQueueTemplate;
import io.camunda.operate.schema.templates.TemplateDescriptor;
import io.camunda.operate.util.CollectionUtil;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Component
@Configuration
public class Migrator {
    private static final Logger LOGGER = LoggerFactory.getLogger(Migrator.class);
    @Autowired
    private List<IndexDescriptor> indexDescriptors;
    @Autowired
    private ListViewTemplate listViewTemplate;
    @Autowired
    private IncidentTemplate incidentTemplate;
    @Autowired
    private PostImporterQueueTemplate postImporterQueueTemplate;
    @Autowired
    private OperateProperties operateProperties;
    @Autowired
    private SchemaManager schemaManager;
    @Autowired
    private StepsRepository stepsRepository;
    @Autowired
    private MigrationProperties migrationProperties;
    @Autowired
    private IndexSchemaValidator indexSchemaValidator;
    @Autowired
    private MigrationPlanFactory migrationPlanFactory;

    @Bean(value={"migrationThreadPoolExecutor"})
    public ThreadPoolTaskExecutor getTaskExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(this.migrationProperties.getThreadsCount());
        executor.setMaxPoolSize(this.migrationProperties.getThreadsCount());
        executor.setThreadNamePrefix("migration_");
        executor.initialize();
        return executor;
    }

    public void migrateData() throws MigrationException {
        try {
            this.stepsRepository.updateSteps();
        }
        catch (IOException e) {
            throw new MigrationException(String.format("Migration failed due to %s", e.getMessage()));
        }
        boolean failed = false;
        List results = this.indexDescriptors.stream().map(this::migrateIndexInThread).collect(Collectors.toList());
        for (Future result : results) {
            try {
                if (((Boolean)result.get()).booleanValue()) continue;
                failed = true;
            }
            catch (Exception e) {
                LOGGER.error("Migration failed: ", (Throwable)e);
                failed = true;
            }
        }
        this.getTaskExecutor().shutdown();
        if (failed) {
            throw new MigrationException("Migration failed. See logging messages above.");
        }
    }

    private Future<Boolean> migrateIndexInThread(IndexDescriptor indexDescriptor) {
        return this.getTaskExecutor().submit(() -> {
            try {
                this.migrateIndexIfNecessary(indexDescriptor);
            }
            catch (Exception e) {
                LOGGER.error("Migration for {} failed:", (Object)indexDescriptor.getIndexName(), (Object)e);
                return false;
            }
            return true;
        });
    }

    private void migrateIndexIfNecessary(IndexDescriptor indexDescriptor) throws MigrationException, IOException {
        LOGGER.info("Check if index {} needs to migrate.", (Object)indexDescriptor.getIndexName());
        Set<String> olderVersions = this.indexSchemaValidator.olderVersionsForIndex(indexDescriptor);
        if (olderVersions.size() > 1) {
            throw new MigrationException(String.format("For index %s are existing more than one older versions: %s ", indexDescriptor.getIndexName(), olderVersions));
        }
        String currentVersion = indexDescriptor.getVersion();
        if (olderVersions.isEmpty()) {
            List<Step> stepsForIndex = this.stepsRepository.findNotAppliedFor(indexDescriptor.getIndexName()).stream().filter(s -> s instanceof DataInitializerStep).collect(Collectors.toList());
            if (stepsForIndex.size() > 0) {
                Plan plan = this.createPlanFor(indexDescriptor.getIndexName(), "1.0.0", currentVersion, stepsForIndex);
                this.migrateIndex(indexDescriptor, plan);
            } else {
                LOGGER.info("No migration needed for {}, no previous indices found and no data initializer.", (Object)indexDescriptor.getIndexName());
            }
        } else {
            String indexPrefix;
            String olderVersion = olderVersions.iterator().next();
            List<Step> stepsForIndex = this.stepsRepository.findNotAppliedFor(indexDescriptor.getIndexName());
            Plan plan = this.createPlanFor(indexDescriptor.getIndexName(), olderVersion, currentVersion, stepsForIndex);
            this.migrateIndex(indexDescriptor, plan);
            String string = indexPrefix = DatabaseInfo.isOpensearch() ? this.operateProperties.getOpensearch().getIndexPrefix() : this.operateProperties.getElasticsearch().getIndexPrefix();
            if (this.migrationProperties.isDeleteSrcSchema()) {
                String olderBaseIndexName = String.format("%s-%s-%s_", indexPrefix, indexDescriptor.getIndexName(), olderVersion);
                String deleteIndexPattern = String.format("%s*", olderBaseIndexName);
                LOGGER.info("Deleted previous indices for pattern {}", (Object)deleteIndexPattern);
                this.schemaManager.deleteIndicesFor(deleteIndexPattern);
                if (indexDescriptor instanceof TemplateDescriptor) {
                    String deleteTemplatePattern = String.format("%stemplate", olderBaseIndexName);
                    LOGGER.info("Deleted previous templates for {}", (Object)deleteTemplatePattern);
                    this.schemaManager.deleteTemplatesFor(deleteTemplatePattern);
                }
            }
        }
    }

    public void migrateIndex(IndexDescriptor indexDescriptor, Plan plan) throws IOException, MigrationException {
        Integer numberOfReplicas;
        String refreshInterval;
        if (DatabaseInfo.isOpensearch()) {
            refreshInterval = this.operateProperties.getOpensearch().getRefreshInterval();
            numberOfReplicas = this.operateProperties.getOpensearch().getNumberOfReplicas();
        } else {
            refreshInterval = this.operateProperties.getElasticsearch().getRefreshInterval();
            numberOfReplicas = this.operateProperties.getElasticsearch().getNumberOfReplicas();
        }
        LOGGER.debug("Save current settings for {}", (Object)indexDescriptor.getFullQualifiedName());
        Map<String, String> indexSettings = this.getIndexSettingsOrDefaultsFor(indexDescriptor, refreshInterval, numberOfReplicas);
        LOGGER.debug("Set reindex settings for {}", (Object)indexDescriptor.getDerivedIndexNamePattern());
        this.schemaManager.setIndexSettingsFor(Map.of("index.number_of_replicas", indexSettings.get("index.number_of_replicas"), "index.refresh_interval", "-1"), indexDescriptor.getDerivedIndexNamePattern());
        LOGGER.info("Execute plan: {} ", (Object)plan);
        plan.executeOn(this.schemaManager);
        LOGGER.debug("Save applied steps in migration repository");
        for (Step step : plan.getSteps()) {
            step.setApplied(true).setAppliedDate(OffsetDateTime.now());
            this.stepsRepository.save(step);
        }
        LOGGER.debug("Restore settings for {}", (Object)indexDescriptor.getDerivedIndexNamePattern());
        this.schemaManager.setIndexSettingsFor(Map.of("index.number_of_replicas", indexSettings.get("index.number_of_replicas"), "index.refresh_interval", indexSettings.get("index.refresh_interval")), indexDescriptor.getDerivedIndexNamePattern());
        LOGGER.info("Refresh index {}", (Object)indexDescriptor.getDerivedIndexNamePattern());
        this.schemaManager.refresh(indexDescriptor.getDerivedIndexNamePattern());
        plan.validateMigrationResults(this.schemaManager);
    }

    private Map<String, String> getIndexSettingsOrDefaultsFor(IndexDescriptor indexDescriptor, String refreshInterval, Integer numberOfReplicas) {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put("index.refresh_interval", this.schemaManager.getOrDefaultRefreshInterval(indexDescriptor.getFullQualifiedName(), refreshInterval));
        settings.put("index.number_of_replicas", this.schemaManager.getOrDefaultNumbersOfReplica(indexDescriptor.getFullQualifiedName(), "" + numberOfReplicas));
        return settings;
    }

    protected Plan createPlanFor(String indexName, String srcVersion, String dstVersion, List<Step> steps) throws MigrationException {
        SemanticVersion sourceVersion = SemanticVersion.fromVersion(srcVersion);
        SemanticVersion destinationVersion = SemanticVersion.fromVersion(dstVersion);
        ArrayList<Step> sortByVersion = new ArrayList<Step>(steps);
        sortByVersion.sort(Step.SEMANTICVERSION_ORDER_COMPARATOR);
        List onlyAffectedVersions = CollectionUtil.filter(sortByVersion, s -> SemanticVersion.fromVersion(s.getVersion()).isBetween(sourceVersion, destinationVersion));
        String indexPrefix = DatabaseInfo.isOpensearch() ? this.operateProperties.getOpensearch().getIndexPrefix() : this.operateProperties.getElasticsearch().getIndexPrefix();
        String srcIndex = String.format("%s-%s-%s", indexPrefix, indexName, srcVersion);
        String dstIndex = String.format("%s-%s-%s", indexPrefix, indexName, dstVersion);
        if (onlyAffectedVersions.stream().anyMatch(s -> s instanceof ProcessorStep) && onlyAffectedVersions.stream().anyMatch(s -> s instanceof SetBpmnProcessIdStep)) {
            throw new MigrationException("Migration plan contains steps that can't be applied together. Check your upgrade path.");
        }
        if (onlyAffectedVersions.size() == 0) {
            ReindexPlan reindexPlan = this.migrationPlanFactory.createReindexPlan();
            return reindexPlan.setSrcIndex(srcIndex).setDstIndex(dstIndex);
        }
        if (onlyAffectedVersions.get(0) instanceof ProcessorStep) {
            ReindexPlan reindexPlan = this.migrationPlanFactory.createReindexPlan();
            return reindexPlan.setSrcIndex(srcIndex).setDstIndex(dstIndex).setSteps(onlyAffectedVersions);
        }
        if (onlyAffectedVersions.get(0) instanceof SetBpmnProcessIdStep && onlyAffectedVersions.size() == 1) {
            String listViewIndexName = String.format("%s-%s", indexPrefix, this.listViewTemplate.getIndexName());
            ReindexWithQueryAndScriptPlan reindexPlan = this.migrationPlanFactory.createReindexWithQueryAndScriptPlan();
            return reindexPlan.setSrcIndex(srcIndex).setDstIndex(dstIndex).setListViewIndexName(listViewIndexName).setSteps(onlyAffectedVersions);
        }
        if (onlyAffectedVersions.get(0) instanceof FillPostImporterQueueStep && onlyAffectedVersions.size() == 1) {
            FillPostImporterQueuePlan fillPostImporterQueuePlan = this.migrationPlanFactory.createFillPostImporterQueuePlan();
            return fillPostImporterQueuePlan.setListViewIndexName(String.format("%s-%s", indexPrefix, this.listViewTemplate.getIndexName())).setIncidentsIndexName(String.format("%s-%s", indexPrefix, this.incidentTemplate.getIndexName())).setPostImporterQueueIndexName(this.postImporterQueueTemplate.getFullQualifiedName()).setSteps(onlyAffectedVersions);
        }
        if ((onlyAffectedVersions.get(0) instanceof SetBpmnProcessIdStep || onlyAffectedVersions.get(0) instanceof FillPostImporterQueueStep) && onlyAffectedVersions.size() > 1) {
            throw new MigrationException("Unexpected migration plan: only one step of this type must be present: " + ((Step)onlyAffectedVersions.get(0)).getClass().getSimpleName());
        }
        throw new MigrationException("Unexpected migration plan.");
    }
}

