/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.schema.indices;

import io.camunda.operate.conditions.DatabaseInfo;
import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.schema.indices.IndexDescriptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;

@Component
@DependsOn(value={"databaseInfo"})
public abstract class AbstractIndexDescriptor
implements IndexDescriptor {
    public static final String SCHEMA_FOLDER_OPENSEARCH = "/schema/opensearch/create";
    public static final String SCHEMA_FOLDER_ELASTICSEARCH = "/schema/elasticsearch/create";
    private static final String SCHEMA_CREATE_INDEX_JSON_OPENSEARCH = "/schema/opensearch/create/index/operate-%s.json";
    private static final String SCHEMA_CREATE_INDEX_JSON_ELASTICSEARCH = "/schema/elasticsearch/create/index/operate-%s.json";
    @Autowired
    protected OperateProperties operateProperties;

    @Override
    public String getFullQualifiedName() {
        return String.format("%s-%s-%s_", this.operateProperties.getIndexPrefix(), this.getIndexName(), this.getVersion());
    }

    @Override
    public String getAllVersionsIndexNameRegexPattern() {
        return String.format("%s-%s-\\d.*", this.operateProperties.getIndexPrefix(), this.getIndexName());
    }

    @Override
    public String getSchemaClasspathFilename() {
        if (DatabaseInfo.isElasticsearch()) {
            return String.format(SCHEMA_CREATE_INDEX_JSON_ELASTICSEARCH, this.getIndexName());
        }
        return String.format(SCHEMA_CREATE_INDEX_JSON_OPENSEARCH, this.getIndexName());
    }
}

