/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.zeebeimport.util;

import io.camunda.operate.entities.ProcessEntity;
import io.camunda.operate.entities.ProcessFlowNodeEntity;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.instance.FlowNode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.camunda.bpm.model.xml.ModelException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Component
@Configuration
public class XMLUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(XMLUtil.class);

    @Bean
    public SAXParserFactory getSAXParserFactory() {
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        saxParserFactory.setNamespaceAware(true);
        try {
            saxParserFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            saxParserFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            saxParserFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            return saxParserFactory;
        }
        catch (ParserConfigurationException | SAXException e) {
            LOGGER.error("Error creating SAXParser", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public Optional<ProcessEntity> extractDiagramData(byte[] byteArray, String bpmnProcessId) {
        SAXParserFactory saxParserFactory = this.getSAXParserFactory();
        ByteArrayInputStream is = new ByteArrayInputStream(byteArray);
        BpmnXmlParserHandler handler = new BpmnXmlParserHandler();
        try {
            saxParserFactory.newSAXParser().parse((InputStream)is, (DefaultHandler)handler);
            ProcessEntity processEntity = handler.getProcessEntity(bpmnProcessId);
            if (processEntity == null) {
                return Optional.empty();
            }
            Set<String> processChildrenIds = handler.getProcessChildrenIds(bpmnProcessId);
            is = new ByteArrayInputStream(byteArray);
            BpmnModelInstance modelInstance = Bpmn.readModelFromStream((InputStream)is);
            Collection flowNodes = modelInstance.getModelElementsByType(FlowNode.class);
            flowNodes.stream().filter(x -> processChildrenIds.contains(x.getId())).toList().forEach(x -> processEntity.getFlowNodes().add(new ProcessFlowNodeEntity(x.getId(), x.getName())));
            return Optional.of(processEntity);
        }
        catch (IOException | ParserConfigurationException | ModelException | SAXException e) {
            LOGGER.warn("Unable to parse diagram: " + e.getMessage(), e);
            return Optional.empty();
        }
    }

    public static class BpmnXmlParserHandler
    extends DefaultHandler {
        private final String processElement = "process";
        private final List<ProcessEntity> processEntities = new ArrayList<ProcessEntity>();
        private final Map<String, Set<String>> processChildrenIds = new LinkedHashMap<String, Set<String>>();
        private String currentProcessId = null;

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            String elementId = attributes.getValue("id");
            if (localName.equalsIgnoreCase("process")) {
                if (elementId == null) {
                    throw new SAXException("Process has null id");
                }
                this.processEntities.add(new ProcessEntity().setBpmnProcessId(elementId).setName(attributes.getValue("name")));
                this.processChildrenIds.put(elementId, new LinkedHashSet());
                this.currentProcessId = elementId;
            } else if (this.currentProcessId != null && elementId != null) {
                this.processChildrenIds.get(this.currentProcessId).add(elementId);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (localName.equalsIgnoreCase("process")) {
                this.currentProcessId = null;
            }
        }

        public ProcessEntity getProcessEntity(String processId) {
            return this.processEntities.stream().filter(x -> Objects.equals(x.getBpmnProcessId(), processId)).findFirst().orElse(null);
        }

        public Set<String> getProcessChildrenIds(String processId) {
            return this.processChildrenIds.containsKey(processId) ? this.processChildrenIds.get(processId) : new HashSet<String>();
        }
    }
}

