/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.zeebeimport.cache;

import io.camunda.operate.Metrics;
import io.camunda.operate.zeebeimport.cache.TreePathCacheMetrics;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;

public class TreePathCacheMetricsImpl
implements TreePathCacheMetrics {
    private final Metrics metrics;
    private final Map<Integer, AtomicInteger> cacheSizes;

    public TreePathCacheMetricsImpl(List<Integer> partitionIds, Metrics metrics) {
        this.metrics = metrics;
        this.cacheSizes = new HashMap<Integer, AtomicInteger>();
        partitionIds.forEach(partitionId -> {
            AtomicInteger cacheSizeRecorder = new AtomicInteger(0);
            this.cacheSizes.put((Integer)partitionId, cacheSizeRecorder);
            metrics.registerGauge("operate.import.fni.tree.path.cache.size", (Object)cacheSizeRecorder, Number::doubleValue, new String[]{"partition", Integer.toString(partitionId)});
        });
    }

    @Override
    public void reportCacheResult(int partitionId, TreePathCacheMetrics.CacheResult result) {
        this.metrics.recordCounts("import.fni.tree.path.cache.result", 1L, new String[]{"partition", Integer.toString(partitionId), "cache.result", result.toString()});
    }

    @Override
    public String recordTimeOfTreePathResolvement(int partitionId, Supplier<String> resolving) {
        return (String)this.metrics.getHistogram("operate.import.fni.tree.path.cache.access", new String[]{"partition", Integer.toString(partitionId)}).record(resolving);
    }

    @Override
    public void reportCacheSize(int partitionId, int size) {
        this.cacheSizes.get(partitionId).set(size);
    }
}

