/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.zeebeimport.cache;

import io.camunda.operate.util.ConversionUtils;
import io.camunda.operate.util.SoftHashMap;
import io.camunda.operate.zeebeimport.cache.FNITreePathCacheCompositeKey;
import io.camunda.operate.zeebeimport.cache.NoopCacheMetrics;
import io.camunda.operate.zeebeimport.cache.TreePathCache;
import io.camunda.operate.zeebeimport.cache.TreePathCacheMetrics;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FlowNodeInstanceTreePathCache
implements TreePathCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlowNodeInstanceTreePathCache.class);
    private final Map<Integer, Map<String, String>> backedTreePathCache = new HashMap<Integer, Map<String, String>>();
    private final Function<Long, String> treePathResolver;
    private final TreePathCacheMetrics treePathCacheMetrics;

    public FlowNodeInstanceTreePathCache(List<Integer> partitionIds, int cacheSize, Function<Long, String> treePathResolver) {
        this(partitionIds, cacheSize, treePathResolver, new NoopCacheMetrics());
    }

    public FlowNodeInstanceTreePathCache(List<Integer> partitionIds, int cacheSize, Function<Long, String> treePathResolver, TreePathCacheMetrics treePathCacheMetrics) {
        partitionIds.forEach(partitionId -> this.backedTreePathCache.computeIfAbsent((Integer)partitionId, id -> new SoftHashMap(cacheSize)));
        this.treePathResolver = treePathResolver;
        this.treePathCacheMetrics = treePathCacheMetrics;
    }

    @Override
    public String resolveParentTreePath(FNITreePathCacheCompositeKey compositeKey) {
        int partitionId = compositeKey.partitionId();
        Map<String, String> partitionCache = this.backedTreePathCache.get(partitionId);
        if (partitionCache == null) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(String.format("Expected to find treePath cache for partitionId %d, but found nothing. Possible partition Ids are: '%s'.", partitionId, this.backedTreePathCache.keySet()));
            LOGGER.error("Couldn't resolve tree path for given partition id {}", (Object)partitionId, (Object)illegalArgumentException);
            throw illegalArgumentException;
        }
        String treePath = this.treePathCacheMetrics.recordTimeOfTreePathResolvement(partitionId, () -> this.resolveTreePath(partitionCache, compositeKey));
        this.treePathCacheMetrics.reportCacheSize(partitionId, partitionCache.size());
        return treePath;
    }

    @Override
    public void cacheTreePath(FNITreePathCacheCompositeKey compositeKey, String treePath) {
        int partitionId = compositeKey.partitionId();
        Map<String, String> partitionCache = this.backedTreePathCache.get(partitionId);
        if (partitionCache == null) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(String.format("Expected to find treePath cache for partitionId %d, but found nothing. Possible partition Ids are: '%s'.", partitionId, this.backedTreePathCache.keySet()));
            LOGGER.error("Couldn't store tree path {} for given key {}", new Object[]{treePath, compositeKey, illegalArgumentException});
            throw illegalArgumentException;
        }
        partitionCache.put(ConversionUtils.toStringOrNull((Object)compositeKey.recordKey()), treePath);
        this.treePathCacheMetrics.reportCacheSize(partitionId, partitionCache.size());
    }

    private String resolveTreePath(Map<String, String> partitionCache, FNITreePathCacheCompositeKey compositeKey) {
        String parentTreePath;
        if (compositeKey.flowScopeKey() == compositeKey.processInstanceKey()) {
            parentTreePath = ConversionUtils.toStringOrNull((Object)compositeKey.processInstanceKey());
        } else {
            TreePathCacheMetrics.CacheResult cacheResult = TreePathCacheMetrics.CacheResult.HIT;
            parentTreePath = partitionCache.get(ConversionUtils.toStringOrNull((Object)compositeKey.flowScopeKey()));
            if (parentTreePath == null) {
                cacheResult = TreePathCacheMetrics.CacheResult.MISS;
                parentTreePath = this.treePathResolver.apply(compositeKey.flowScopeKey());
                LOGGER.debug("Cache miss: resolved treePath {} for flowScopeKey {} via given resolver.", (Object)parentTreePath, (Object)compositeKey.flowScopeKey());
                if (parentTreePath != null) {
                    partitionCache.put(ConversionUtils.toStringOrNull((Object)compositeKey.flowScopeKey()), parentTreePath);
                } else {
                    LOGGER.warn("Unable to find parent tree path for flow node instance id [{}], parent flow node instance id [{}]", (Object)compositeKey.recordKey(), (Object)compositeKey.flowScopeKey());
                    parentTreePath = ConversionUtils.toStringOrNull((Object)compositeKey.processInstanceKey());
                }
            }
            this.treePathCacheMetrics.reportCacheResult(compositeKey.partitionId(), cacheResult);
        }
        return parentTreePath;
    }
}

