/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.zeebeimport;

import com.auth0.jwt.JWT;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.camunda.operate.exceptions.OperateRuntimeException;
import io.camunda.operate.property.OperateProperties;
import java.util.Date;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
@Configuration
public class M2mTokenManager {
    protected static final String FIELD_NAME_GRANT_TYPE = "grant_type";
    protected static final String GRANT_TYPE_VALUE = "client_credentials";
    protected static final String FIELD_NAME_CLIENT_ID = "client_id";
    protected static final String FIELD_NAME_CLIENT_SECRET = "client_secret";
    protected static final String FIELD_NAME_AUDIENCE = "audience";
    protected static final String FIELD_NAME_ACCESS_TOKEN = "access_token";
    @Autowired
    private OperateProperties operateProperties;
    @Autowired
    @Qualifier(value="operateObjectMapper")
    private ObjectMapper objectMapper;
    @Autowired
    private RestTemplateBuilder builder;
    private String token;
    private Date tokenExpiresAt;
    private final Object cacheLock = new Object();

    @Bean(name={"incidentNotificationRestTemplate"})
    public RestTemplate getRestTemplate() {
        return this.builder.build();
    }

    public String getToken() {
        return this.getToken(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getToken(boolean forceTokenUpdate) {
        if (this.token == null || this.tokenIsExpired() || forceTokenUpdate) {
            Object object = this.cacheLock;
            synchronized (object) {
                if (this.token == null || this.tokenIsExpired() || forceTokenUpdate) {
                    this.token = this.getNewToken();
                    this.tokenExpiresAt = JWT.decode((String)this.token).getExpiresAt();
                }
            }
        }
        return this.token;
    }

    private boolean tokenIsExpired() {
        return this.tokenExpiresAt != null && !this.tokenExpiresAt.after(new Date());
    }

    private String getNewToken() {
        String tokenURL = String.format("https://%s/oauth/token", this.operateProperties.getAuth0().getDomain());
        ObjectNode request = this.createGetTokenRequest();
        ResponseEntity response = this.getRestTemplate().postForEntity(tokenURL, (Object)request, Map.class, new Object[0]);
        if (!response.getStatusCode().equals((Object)HttpStatus.OK)) {
            throw new OperateRuntimeException(String.format("Unable to get the M2M auth token, response status: %s.", response.getStatusCode()));
        }
        return (String)((Map)response.getBody()).get(FIELD_NAME_ACCESS_TOKEN);
    }

    private ObjectNode createGetTokenRequest() {
        ObjectNode request = this.objectMapper.createObjectNode().put(FIELD_NAME_GRANT_TYPE, GRANT_TYPE_VALUE).put(FIELD_NAME_CLIENT_ID, this.operateProperties.getAuth0().getM2mClientId()).put(FIELD_NAME_CLIENT_SECRET, this.operateProperties.getAuth0().getM2mClientSecret()).put(FIELD_NAME_AUDIENCE, this.operateProperties.getAuth0().getM2mAudience());
        return request;
    }

    protected void clearCache() {
        this.token = null;
        this.tokenExpiresAt = null;
    }
}

