/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.zeebeimport;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.cache.ProcessCache;
import io.camunda.operate.entities.IncidentEntity;
import io.camunda.operate.entities.ProcessEntity;
import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.util.CollectionUtil;
import io.camunda.operate.zeebeimport.M2mTokenManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class IncidentNotifier {
    protected static final String FIELD_NAME_ALERTS = "alerts";
    protected static final String FIELD_NAME_MESSAGE = "message";
    protected static final String MESSAGE = "Incident created";
    protected static final String FIELD_NAME_ID = "id";
    protected static final String FIELD_NAME_PROCESS_INSTANCE_ID = "processInstanceId";
    protected static final String FIELD_NAME_CREATION_TIME = "creationTime";
    protected static final String FIELD_NAME_STATE = "state";
    protected static final String FIELD_NAME_ERROR_MESSAGE = "errorMessage";
    protected static final String FIELD_NAME_ERROR_TYPE = "errorType";
    protected static final String FIELD_NAME_FLOW_NODE_ID = "flowNodeId";
    protected static final String FIELD_NAME_FLOW_NODE_INSTANCE_KEY = "flowNodeInstanceKey";
    protected static final String FIELD_NAME_JOB_KEY = "jobKey";
    protected static final String FIELD_NAME_PROCESS_KEY = "processDefinitionKey";
    protected static final String FIELD_NAME_BPMN_PROCESS_ID = "bpmnProcessId";
    protected static final String FIELD_NAME_PROCESS_NAME = "processName";
    protected static final String FIELD_NAME_PROCESS_VERSION = "processVersion";
    private static final Logger LOGGER = LoggerFactory.getLogger(IncidentNotifier.class);
    @Autowired
    private OperateProperties operateProperties;
    @Autowired
    @Qualifier(value="operateObjectMapper")
    private ObjectMapper objectMapper;
    @Autowired
    private M2mTokenManager m2mTokenManager;
    @Autowired
    @Qualifier(value="incidentNotificationRestTemplate")
    private RestTemplate restTemplate;
    @Autowired
    private ProcessCache processCache;

    public void notifyOnIncidents(List<IncidentEntity> incidents) {
        try {
            HttpStatusCode status = this.notifyOnIncidents(incidents, this.m2mTokenManager.getToken());
            if (status.is2xxSuccessful()) {
                LOGGER.debug("Incident notification is sent");
            } else if (status.isSameCodeAs((HttpStatusCode)HttpStatus.UNAUTHORIZED)) {
                LOGGER.debug("Incident notification recieved 401 response");
                status = this.notifyOnIncidents(incidents, this.m2mTokenManager.getToken(true));
                if (status.is2xxSuccessful()) {
                    LOGGER.debug("Incident notification is sent");
                } else {
                    LOGGER.error("Failed to send incident notification. Response status: " + String.valueOf(status));
                }
            } else {
                LOGGER.error("Failed to send incident notification. Response status: " + String.valueOf(status));
            }
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Failed to create incident notification request: " + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("Failed to notify on incidents: " + e.getMessage(), (Throwable)e);
        }
    }

    private HttpStatusCode notifyOnIncidents(List<IncidentEntity> incidents, String m2mToken) throws JsonProcessingException {
        String webhookURL = this.operateProperties.getAlert().getWebhook();
        String payload = this.getIncidentsAsJSON(incidents);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setBearerAuth(m2mToken);
        HttpEntity request = new HttpEntity((Object)payload, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(webhookURL, (Object)request, String.class, new Object[0]);
        return response.getStatusCode();
    }

    private String getIncidentsAsJSON(List<IncidentEntity> incidents) throws JsonProcessingException {
        ArrayList incidentList = new ArrayList();
        for (IncidentEntity inc : incidents) {
            HashMap<String, Object> incidentFields = new HashMap<String, Object>();
            incidentFields.put(FIELD_NAME_MESSAGE, MESSAGE);
            incidentFields.put(FIELD_NAME_ID, inc.getId());
            incidentFields.put(FIELD_NAME_PROCESS_INSTANCE_ID, String.valueOf(inc.getProcessInstanceKey()));
            incidentFields.put(FIELD_NAME_CREATION_TIME, inc.getCreationTime());
            incidentFields.put(FIELD_NAME_STATE, inc.getState());
            incidentFields.put(FIELD_NAME_ERROR_MESSAGE, inc.getErrorMessage());
            incidentFields.put(FIELD_NAME_ERROR_TYPE, inc.getErrorType());
            incidentFields.put(FIELD_NAME_FLOW_NODE_ID, inc.getFlowNodeId());
            incidentFields.put(FIELD_NAME_FLOW_NODE_INSTANCE_KEY, inc.getFlowNodeInstanceKey());
            incidentFields.put(FIELD_NAME_JOB_KEY, inc.getJobKey());
            incidentFields.put(FIELD_NAME_PROCESS_KEY, inc.getProcessDefinitionKey());
            Optional process = this.processCache.findOrWaitProcess(inc.getProcessDefinitionKey(), 2, 1000L);
            if (process.isPresent()) {
                incidentFields.put(FIELD_NAME_BPMN_PROCESS_ID, ((ProcessEntity)process.get()).getBpmnProcessId());
                incidentFields.put(FIELD_NAME_PROCESS_NAME, ((ProcessEntity)process.get()).getName());
                incidentFields.put(FIELD_NAME_PROCESS_VERSION, ((ProcessEntity)process.get()).getVersion());
            }
            incidentList.add(incidentFields);
        }
        return this.objectMapper.writeValueAsString((Object)CollectionUtil.asMap((Object[])new Object[]{FIELD_NAME_ALERTS, incidentList}));
    }
}

