/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.zeebeimport;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.camunda.operate.entities.HitEntity;
import io.camunda.operate.zeebe.ImportValueType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportBatch {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImportBatch.class);
    private int partitionId;
    private ImportValueType importValueType;
    private List<HitEntity> hits;
    private String lastRecordIndexName;
    private int finishedWiCount = 0;
    private OffsetDateTime scheduledTime;

    public ImportBatch(int partitionId, ImportValueType importValueType, List<HitEntity> hits, String lastRecordIndexName) {
        this.partitionId = partitionId;
        this.importValueType = importValueType;
        this.hits = hits;
        this.lastRecordIndexName = lastRecordIndexName;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public void setPartitionId(int partitionId) {
        this.partitionId = partitionId;
    }

    public ImportValueType getImportValueType() {
        return this.importValueType;
    }

    public void setImportValueType(ImportValueType importValueType) {
        this.importValueType = importValueType;
    }

    public List<HitEntity> getHits() {
        return this.hits;
    }

    public void setHits(List<HitEntity> hits) {
        this.hits = hits;
    }

    public int getRecordsCount() {
        return this.hits.size();
    }

    public void incrementFinishedWiCount() {
        ++this.finishedWiCount;
    }

    public int getFinishedWiCount() {
        return this.finishedWiCount;
    }

    public String getLastRecordIndexName() {
        return this.lastRecordIndexName;
    }

    public void setLastRecordIndexName(String lastRecordIndexName) {
        this.lastRecordIndexName = lastRecordIndexName;
    }

    public Long getLastProcessedPosition(ObjectMapper objectMapper) {
        return this.getLastProcessed("position", objectMapper, 0L);
    }

    public Long getLastProcessedSequence(ObjectMapper objectMapper) {
        return this.getLastProcessed("sequence", objectMapper, 0L);
    }

    private long getLastProcessed(String fieldName, ObjectMapper objectMapper, Long defaultValue) {
        try {
            ObjectNode node;
            if (this.hits != null && this.hits.size() != 0 && (node = (ObjectNode)objectMapper.readValue(this.hits.get(this.hits.size() - 1).getSourceAsString(), ObjectNode.class)).has(fieldName)) {
                return node.get(fieldName).longValue();
            }
        }
        catch (IOException e) {
            LOGGER.warn(String.format("Unable to parse Zeebe object for getting field %s : %s", fieldName, e.getMessage()), (Throwable)e);
        }
        return defaultValue;
    }

    public String getAliasName() {
        return this.importValueType.getAliasTemplate();
    }

    public OffsetDateTime getScheduledTime() {
        return this.scheduledTime;
    }

    public ImportBatch setScheduledTime(OffsetDateTime scheduledTime) {
        this.scheduledTime = scheduledTime;
        return this;
    }

    public int hashCode() {
        int result = this.partitionId;
        result = 31 * result + (this.importValueType != null ? this.importValueType.hashCode() : 0);
        result = 31 * result + (this.hits != null ? this.hits.hashCode() : 0);
        result = 31 * result + (this.lastRecordIndexName != null ? this.lastRecordIndexName.hashCode() : 0);
        result = 31 * result + this.finishedWiCount;
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImportBatch that = (ImportBatch)o;
        if (this.partitionId != that.partitionId) {
            return false;
        }
        if (this.finishedWiCount != that.finishedWiCount) {
            return false;
        }
        if (this.importValueType != that.importValueType) {
            return false;
        }
        if (!Objects.equals(this.hits, that.hits)) {
            return false;
        }
        return Objects.equals(this.lastRecordIndexName, that.lastRecordIndexName);
    }
}

