/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.zeebeimport;

import io.camunda.operate.Metrics;
import io.camunda.operate.exceptions.PersistenceException;
import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.store.BatchRequest;
import io.camunda.operate.zeebeimport.ImportBatch;
import io.camunda.operate.zeebeimport.ImportBatchProcessor;
import java.util.concurrent.Callable;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractImportBatchProcessor
implements ImportBatchProcessor {
    @Autowired
    private BeanFactory beanFactory;
    @Autowired
    private OperateProperties operateProperties;
    @Autowired
    private Metrics metrics;

    @Override
    public void performImport(ImportBatch importBatch) throws PersistenceException {
        BatchRequest batchRequest = (BatchRequest)this.beanFactory.getBean(BatchRequest.class);
        try {
            this.withProcessingTimer(() -> {
                this.processZeebeRecords(importBatch, batchRequest);
                return null;
            }, importBatch);
            this.withImportIndexQueryTimer(() -> {
                batchRequest.execute();
                return null;
            }, importBatch);
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    private void withProcessingTimer(Callable<Void> callable, ImportBatch importBatch) throws Exception {
        this.withTimer(callable, "operate.import.processing.duration", importBatch);
    }

    private void withImportIndexQueryTimer(Callable<Void> callable, ImportBatch importBatch) throws Exception {
        this.withTimer(callable, "operate.import.index.query", importBatch);
    }

    private void withTimer(Callable<Void> callable, String timerName, ImportBatch importBatch) throws Exception {
        this.metrics.getTimer(timerName, new String[]{"type", importBatch.getImportValueType().name(), "partition", String.valueOf(importBatch.getPartitionId())}).recordCallable(callable);
    }

    protected abstract void processZeebeRecords(ImportBatch var1, BatchRequest var2) throws PersistenceException;
}

